/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.FunctionIntrinsics;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.objects.ObjectIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.objects.ObjectIntrinsics;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsics;
import org.jetbrains.kotlin.psi.KtBinaryExpression;

public final class Intrinsics {
    private final FunctionIntrinsics functionIntrinsics = new FunctionIntrinsics();
    private final BinaryOperationIntrinsics binaryOperationIntrinsics = new BinaryOperationIntrinsics();
    private final ObjectIntrinsics objectIntrinsics = new ObjectIntrinsics();

    @NotNull
    public BinaryOperationIntrinsic getBinaryOperationIntrinsic(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/intrinsic/Intrinsics", "getBinaryOperationIntrinsic"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/Intrinsics", "getBinaryOperationIntrinsic"));
        }
        BinaryOperationIntrinsic binaryOperationIntrinsic = this.binaryOperationIntrinsics.getIntrinsic(expression, context);
        if (binaryOperationIntrinsic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/Intrinsics", "getBinaryOperationIntrinsic"));
        }
        return binaryOperationIntrinsic;
    }

    @NotNull
    public FunctionIntrinsic getFunctionIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/intrinsic/Intrinsics", "getFunctionIntrinsic"));
        }
        FunctionIntrinsic functionIntrinsic = this.functionIntrinsics.getIntrinsic(descriptor2);
        if (functionIntrinsic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/Intrinsics", "getFunctionIntrinsic"));
        }
        return functionIntrinsic;
    }

    @NotNull
    public ObjectIntrinsic getObjectIntrinsic(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/js/translate/intrinsic/Intrinsics", "getObjectIntrinsic"));
        }
        ObjectIntrinsic objectIntrinsic = this.objectIntrinsics.getIntrinsic(classDescriptor);
        if (objectIntrinsic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/Intrinsics", "getObjectIntrinsic"));
        }
        return objectIntrinsic;
    }
}

