/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportList;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;

public class ImportsUtil {
    private ImportsUtil() {
    }

    public static List<PsiJavaCodeReferenceElement> collectReferencesThrough(PsiFile file, final @Nullable PsiJavaCodeReferenceElement refExpr, final PsiImportStaticStatement staticImport) {
        final ArrayList<PsiJavaCodeReferenceElement> expressionToExpand = new ArrayList<PsiJavaCodeReferenceElement>();
        file.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement expression) {
                PsiElement resolveScope;
                if ((refExpr == null || refExpr != expression) && (resolveScope = expression.advancedResolve(true).getCurrentFileResolveScope()) == staticImport) {
                    expressionToExpand.add(expression);
                }
                super.visitElement(expression);
            }
        });
        return expressionToExpand;
    }

    public static void replaceAllAndDeleteImport(List<PsiJavaCodeReferenceElement> expressionToExpand, @Nullable PsiJavaCodeReferenceElement refExpr, PsiImportStaticStatement staticImport) {
        if (refExpr != null) {
            expressionToExpand.add(refExpr);
        }
        Collections.sort(expressionToExpand, new Comparator<PsiJavaCodeReferenceElement>(){

            @Override
            public int compare(PsiJavaCodeReferenceElement o1, PsiJavaCodeReferenceElement o2) {
                return o2.getTextOffset() - o1.getTextOffset();
            }
        });
        for (PsiJavaCodeReferenceElement expression : expressionToExpand) {
            ImportsUtil.expand(expression, staticImport);
        }
        staticImport.delete();
    }

    public static void expand(@NotNull PsiJavaCodeReferenceElement refExpr, PsiImportStaticStatement staticImport) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "org/jetbrains/kotlin/com/intellij/psi/util/ImportsUtil", "expand"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(refExpr.getProject());
        PsiReferenceExpression referenceExpression = elementFactory.createReferenceExpression(staticImport.resolveTargetClass());
        if (refExpr instanceof PsiReferenceExpression) {
            ((PsiReferenceExpression)refExpr).setQualifierExpression(referenceExpression);
        } else {
            refExpr.replace(elementFactory.createReferenceFromText(referenceExpression.getText() + "." + refExpr.getText(), refExpr));
        }
    }

    public static boolean hasStaticImportOn(PsiElement expr, PsiMember member, boolean acceptOnDemand) {
        PsiImportList importList;
        if (expr.getContainingFile() instanceof PsiJavaFile && (importList = ((PsiJavaFile)expr.getContainingFile()).getImportList()) != null) {
            PsiImportStaticStatement[] importStaticStatements;
            for (PsiImportStaticStatement stmt : importStaticStatements = importList.getImportStaticStatements()) {
                PsiClass containingClass = member.getContainingClass();
                String referenceName = stmt.getReferenceName();
                if (containingClass == null || stmt.resolveTargetClass() != containingClass) continue;
                if (!stmt.isOnDemand() && Comparing.strEqual(referenceName, member.getName())) {
                    if (member instanceof PsiMethod) {
                        return containingClass.findMethodsByName(referenceName, false).length == 1;
                    }
                    return true;
                }
                if (!acceptOnDemand || !stmt.isOnDemand()) continue;
                return true;
            }
        }
        return false;
    }
}

