/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.DefaultASTFactory;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.CorePsiDocTagValueImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.PsiDocTokenImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiIdentifierImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiJavaTokenImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiKeywordImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.java.IJavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.java.IJavaElementType;

public class CoreJavaASTFactory
extends ASTFactory
implements Constants {
    private final DefaultASTFactory myDefaultASTFactory = ServiceManager.getService(DefaultASTFactory.class);

    @Override
    public LeafElement createLeaf(@NotNull IElementType type2, @NotNull CharSequence text) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/CoreJavaASTFactory", "createLeaf"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/CoreJavaASTFactory", "createLeaf"));
        }
        if (type2 == C_STYLE_COMMENT || type2 == END_OF_LINE_COMMENT) {
            return this.myDefaultASTFactory.createComment(type2, text);
        }
        if (type2 == IDENTIFIER) {
            return new PsiIdentifierImpl(text);
        }
        if (KEYWORD_BIT_SET.contains(type2)) {
            return new PsiKeywordImpl(type2, text);
        }
        if (type2 instanceof IJavaElementType) {
            return new PsiJavaTokenImpl(type2, text);
        }
        if (type2 instanceof IJavaDocElementType) {
            assert (type2 != DOC_TAG_VALUE_ELEMENT);
            return new PsiDocTokenImpl(type2, text);
        }
        return null;
    }

    @Override
    public CompositeElement createComposite(IElementType type2) {
        if (type2 == DOC_TAG_VALUE_ELEMENT) {
            return new CorePsiDocTagValueImpl();
        }
        return null;
    }
}

