/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.FrozenDocument;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiFileRange;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.MarkerCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private static final ReferenceQueue<SmartPsiElementPointerImpl> ourQueue = new ReferenceQueue();
    private static final LowMemoryWatcher ourWatcher = LowMemoryWatcher.register(new Runnable(){

        @Override
        public void run() {
            SmartPointerManagerImpl.processQueue();
        }
    });
    private final Project myProject;
    private final Key<FilePointersList> POINTERS_KEY;
    private final PsiDocumentManagerBase myPsiDocManager;
    private static final Key<Reference<SmartPsiElementPointerImpl>> CACHED_SMART_POINTER_KEY = Key.create("CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(Project project) {
        this.myProject = project;
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        this.POINTERS_KEY = Key.create("SMART_POINTERS for " + project);
    }

    private static void processQueue() {
        PointerReference reference;
        while ((reference = (PointerReference)ourQueue.poll()) != null) {
            FilePointersList pointers = (FilePointersList)reference.file.getUserData(reference.key);
            if (pointers == null) continue;
            pointers.remove(reference);
        }
    }

    public void fastenBelts(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "fastenBelts"));
        }
        SmartPointerManagerImpl.processQueue();
        FilePointersList pointers = this.getPointers(file);
        if (pointers != null) {
            pointers.processAlivePointers(new Processor<SmartPsiElementPointerImpl>(){

                @Override
                public boolean process(SmartPsiElementPointerImpl pointer) {
                    pointer.getElementInfo().fastenBelt();
                    return true;
                }
            });
        }
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        if (containingFile != null && !containingFile.isValid() || containingFile == null && !element.isValid()) {
            PsiUtilCore.ensureValid(element);
            LOG.error("Invalid element:" + element);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (pointer != null && pointer.incrementAndGetReferenceCount(1) > 0) {
            SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
            if (smartPsiElementPointerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
            }
            return smartPsiElementPointerImpl;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element, containingFile);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element.putUserData(CACHED_SMART_POINTER_KEY, new SoftReference<SmartPsiElementPointerImpl<E>>(pointer));
        SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
        if (smartPsiElementPointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointerImpl;
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element) {
        Object cachedElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedPointer"));
        }
        Reference<SmartPsiElementPointerImpl> data = element.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPsiElementPointerImpl cachedPointer = SoftReference.dereference(data);
        if (cachedPointer != null && ((cachedElement = cachedPointer.getElement()) == null || cachedElement != element)) {
            return null;
        }
        return cachedPointer;
    }

    @Override
    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        SmartPsiFileRange smartPsiFileRange = this.createSmartPsiFileRangePointer(file, range, false);
        if (smartPsiFileRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRange;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range, boolean forInjected) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (!file.isValid()) {
            LOG.error("Invalid element:" + file);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(file, ProperTextRange.create(range), forInjected);
        this.trackPointer(pointer, file.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRangePointerImpl;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        block4: {
            FilePointersList pointers;
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "trackPointer"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "trackPointer"));
            }
            SmartPointerElementInfo info = pointer.getElementInfo();
            if (!(info instanceof SelfElementInfo)) {
                return;
            }
            do {
                if ((pointers = this.getPointers(containingFile)) != null) continue;
                pointers = containingFile.putUserDataIfAbsent(this.POINTERS_KEY, new FilePointersList());
            } while (!pointers.add(new PointerReference(pointer, containingFile, SmartPointerManagerImpl.ourQueue, this.POINTERS_KEY)));
            if (!((SelfElementInfo)info).hasRange()) break block4;
            pointers.markerCache.rangeChanged();
        }
    }

    @Override
    public void removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "removePointer"));
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        PsiFile containingFile = pointer.getContainingFile();
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == 0) {
            PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
            if (element != null) {
                element.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info.cleanup();
            if (containingFile == null) {
                return;
            }
            VirtualFile vFile = containingFile.getViewProvider().getVirtualFile();
            FilePointersList pointers = this.getPointers(vFile);
            if (pointers == null) {
                return;
            }
            pointers.remove(pointer);
        }
    }

    @Nullable
    private FilePointersList getPointers(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointers"));
        }
        return containingFile.getUserData(this.POINTERS_KEY);
    }

    @Nullable
    MarkerCache getMarkerCache(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getMarkerCache"));
        }
        FilePointersList pointers = this.getPointers(file);
        return pointers == null ? null : pointers.markerCache;
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointersNumber"));
        }
        VirtualFile file = containingFile.getViewProvider().getVirtualFile();
        FilePointersList pointers = this.getPointers(file);
        return pointers == null ? 0 : pointers.getSize();
    }

    @Override
    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer1", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer2", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(Document document, FrozenDocument frozen, List<DocumentEvent> events) {
        FilePointersList list2;
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        FilePointersList filePointersList = list2 = file == null ? null : this.getPointers(file);
        if (list2 == null) {
            return;
        }
        list2.markerCache.updateMarkers(frozen, events);
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "updatePointerTargetsAfterReparse"));
        }
        FilePointersList list2 = this.getPointers(file);
        if (list2 == null) {
            return;
        }
        list2.processAlivePointers(new Processor<SmartPsiElementPointerImpl>(){

            @Override
            public boolean process(SmartPsiElementPointerImpl pointer) {
                if (!(pointer instanceof SmartPsiFileRangePointerImpl)) {
                    SmartPointerManagerImpl.updatePointerTarget(pointer, pointer.getPsiRange());
                }
                return true;
            }
        });
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "updatePointerTarget"));
        }
        E cachedElement = pointer.getCachedElement();
        if (cachedElement == null || cachedElement.isValid() && pointerRange != null && pointerRange.equals(cachedElement.getTextRange())) {
            return;
        }
        E newTarget = pointer.doRestoreElement();
        if (newTarget != null) {
            pointer.cacheElement(newTarget);
        }
    }

    Project getProject() {
        return this.myProject;
    }

    PsiDocumentManagerBase getPsiDocumentManager() {
        return this.myPsiDocManager;
    }

    static class FilePointersList {
        private int nextAvailableIndex;
        private int size;
        private PointerReference[] references = new PointerReference[10];
        private final MarkerCache markerCache = new MarkerCache(this);
        private boolean mySorted;

        FilePointersList() {
        }

        private synchronized boolean add(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "add"));
            }
            if (reference.file.getUserData(reference.key) != this) {
                return false;
            }
            if (this.nextAvailableIndex >= this.references.length || this.nextAvailableIndex > this.size * 2) {
                int newCapacity = this.nextAvailableIndex >= this.references.length ? this.references.length * 3 / 2 + 1 : this.size * 3 / 2 + 1;
                PointerReference[] newReferences = new PointerReference[newCapacity];
                int o = 0;
                for (PointerReference oldRef : this.references) {
                    if (SoftReference.dereference(oldRef) == null) continue;
                    newReferences[o++] = oldRef;
                }
                this.references = newReferences;
                this.size = this.nextAvailableIndex = o;
            }
            this.references[this.nextAvailableIndex++] = reference;
            ++this.size;
            this.mySorted = false;
            return true;
        }

        private synchronized void remove(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "remove"));
            }
            int index2 = ArrayUtil.indexOf(this.references, reference, 0, this.nextAvailableIndex);
            if (index2 != -1) {
                this.removeReference(reference, index2);
            }
        }

        private synchronized void remove(@NotNull SmartPsiElementPointer smartPointer) {
            if (smartPointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartPointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "remove"));
            }
            for (int i = 0; i < this.nextAvailableIndex; ++i) {
                PointerReference reference = this.references[i];
                if (reference == null || reference.get() != smartPointer) continue;
                this.removeReference(reference, i);
                return;
            }
        }

        private void removeReference(@NotNull PointerReference reference, int index2) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "removeReference"));
            }
            this.references[index2] = null;
            if (--this.size == 0) {
                reference.file.replace(reference.key, this, null);
            }
        }

        boolean processAlivePointers(@NotNull Processor<SmartPsiElementPointerImpl> processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "processAlivePointers"));
            }
            for (int i = 0; i < this.nextAvailableIndex; ++i) {
                SmartPsiElementPointerImpl pointer = SoftReference.dereference(this.references[i]);
                if (pointer == null || processor.process(pointer)) continue;
                return false;
            }
            return true;
        }

        synchronized List<SelfElementInfo> getSortedInfos() {
            SmartPsiElementPointerImpl pointer;
            PointerReference reference;
            int i;
            if (!this.mySorted) {
                ArrayList hardRefs = ContainerUtil.newArrayListWithCapacity(this.size);
                for (i = 0; i < this.nextAvailableIndex; ++i) {
                    reference = this.references[i];
                    if (reference == null) continue;
                    pointer = (SmartPsiElementPointerImpl)reference.get();
                    if (pointer != null) {
                        hardRefs.add(pointer);
                        continue;
                    }
                    this.removeReference(reference, i);
                    if (this.size != 0) continue;
                    return Collections.emptyList();
                }
                assert (this.size == hardRefs.size());
                Arrays.sort(this.references, 0, this.nextAvailableIndex, new Comparator<PointerReference>(){

                    @Override
                    public int compare(PointerReference o1, PointerReference o2) {
                        SmartPsiElementPointerImpl p1 = SoftReference.dereference(o1);
                        SmartPsiElementPointerImpl p2 = SoftReference.dereference(o2);
                        if (p1 == null || p2 == null) {
                            return p1 != null ? -1 : (p2 != null ? 1 : 0);
                        }
                        return MarkerCache.INFO_COMPARATOR.compare((SelfElementInfo)p1.getElementInfo(), (SelfElementInfo)p2.getElementInfo());
                    }
                });
                this.nextAvailableIndex = hardRefs.size();
                this.mySorted = true;
            }
            ArrayList<SelfElementInfo> infos = ContainerUtil.newArrayListWithCapacity(this.size);
            for (i = 0; i < this.nextAvailableIndex; ++i) {
                reference = this.references[i];
                pointer = SoftReference.dereference(reference);
                if (pointer == null) continue;
                SelfElementInfo info = (SelfElementInfo)pointer.getElementInfo();
                if (!info.hasRange()) break;
                infos.add(info);
            }
            return infos;
        }

        int getSize() {
            return this.size;
        }

        synchronized void markUnsorted() {
            this.mySorted = false;
        }
    }

    private static class PointerReference
    extends WeakReference<SmartPsiElementPointerImpl> {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final Key<FilePointersList> key;

        private PointerReference(@NotNull SmartPsiElementPointerImpl<?> pointer, @NotNull VirtualFile containingFile, @NotNull ReferenceQueue<SmartPsiElementPointerImpl> queue, @NotNull Key<FilePointersList> key) {
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            super(pointer, queue);
            this.file = containingFile;
            this.key = key;
        }
    }
}

