/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.codeStyle;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.MinusculeMatcher;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;
import org.jetbrains.kotlin.com.intellij.util.ui.KeyboardLayoutUtil;

public class FixingLayoutMatcher
extends MinusculeMatcher {
    @Nullable
    private final MinusculeMatcher myFixedMatcher;

    FixingLayoutMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/FixingLayoutMatcher", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/FixingLayoutMatcher", "<init>"));
        }
        super(pattern, options, hardSeparators);
        String s = FixingLayoutMatcher.fixPattern(pattern);
        this.myFixedMatcher = s == null ? null : new MinusculeMatcher(s, options, hardSeparators);
    }

    @Nullable
    private static String fixPattern(String pattern) {
        boolean hasLetters = false;
        boolean onlyWrongLetters = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (!Character.isLetter(c)) continue;
            hasLetters = true;
            if (c > '\u007f') continue;
            onlyWrongLetters = false;
            break;
        }
        if (hasLetters && onlyWrongLetters) {
            char[] alternatePattern = new char[pattern.length()];
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                Character newC = KeyboardLayoutUtil.getAsciiForChar(c);
                alternatePattern[i] = newC == null ? c : newC.charValue();
            }
            return new String(alternatePattern);
        }
        return null;
    }

    @Override
    public boolean matches(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/FixingLayoutMatcher", "matches"));
        }
        return super.matches(name) || this.myFixedMatcher != null && this.myFixedMatcher.matches(name);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/FixingLayoutMatcher", "matchingFragments"));
        }
        FList<TextRange> ranges2 = super.matchingFragments(name);
        if (this.myFixedMatcher == null || ranges2 != null && !ranges2.isEmpty()) {
            return ranges2;
        }
        return this.myFixedMatcher.matchingFragments(name);
    }
}

