/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;

public class PsiLambdaParameterType
extends PsiType {
    private final PsiParameter myParameter;

    public PsiLambdaParameterType(PsiParameter parameter) {
        super(TypeAnnotationProvider.EMPTY);
        this.myParameter = parameter;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        if ("<lambda parameter>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiLambdaParameterType", "getPresentableText"));
        }
        return "<lambda parameter>";
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiLambdaParameterType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiLambdaParameterType", "getInternalCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean isValid() {
        return this.myParameter.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull @NonNls String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/PsiLambdaParameterType", "equalsToText"));
        }
        return false;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/PsiLambdaParameterType", "accept"));
        }
        return visitor2.visitType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return null;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiLambdaParameterType", "getSuperTypes"));
        }
        return PsiType.EMPTY_ARRAY;
    }

    public PsiParameter getParameter() {
        return this.myParameter;
    }
}

