/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.serialization.js.ClassSerializationUtil;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.JsProtoBuf;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragmentProviderKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil$WhenMappings;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtilKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePathsKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializerExtension;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012J.\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0003J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u000eH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001d2\u0006\u0010 \u001a\u00020\u0016H\u0002J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0&H\u0002J\u0014\u0010'\u001a\u00020\u00072\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160)J(\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140)2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0016H\u0007JT\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u001f2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u000207052\u0018\u00108\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\"09H\u0002J0\u0010:\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u001f2\u0018\u00108\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\"09J\u001a\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010 \u001a\u00020\u0016J\u0012\u0010<\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00160)H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil;", "", "()V", "CLASSES_IN_PACKAGE_DEFAULT_BYTES", "", "kotlin.jvm.PlatformType", "CLASS_METADATA_FILE_EXTENSION", "", "getCLASS_METADATA_FILE_EXTENSION", "()Ljava/lang/String;", "PACKAGE_DEFAULT_BYTES", "STRING_TABLE_DEFAULT_BYTES", "contentMapToByteArray", "contentMap", "", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "importedModules", "", "createPackageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "getFileName", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getPackages", "", "getPackagesFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "module", "getSubPackagesFqNames", "", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "result", "", "metadataAsString", "jsDescriptor", "Lorg/jetbrains/kotlin/serialization/js/JsModuleDescriptor;", "readModule", "metadata", "kotlinModule", "serializeClassNamesInPackage", "fqName", "packageFragments", "", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "stringTable", "Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "skip", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "", "writeFun", "Lkotlin/Function2;", "serializePackage", "toContentMap", "toBinaryMetadata", "kotlin-compiler"})
public final class KotlinJavascriptSerializationUtil {
    @NotNull
    private static final String CLASS_METADATA_FILE_EXTENSION = "kjsm";
    private static final byte[] PACKAGE_DEFAULT_BYTES;
    private static final byte[] CLASSES_IN_PACKAGE_DEFAULT_BYTES;
    private static final byte[] STRING_TABLE_DEFAULT_BYTES;
    public static final KotlinJavascriptSerializationUtil INSTANCE;

    @NotNull
    public final String getCLASS_METADATA_FILE_EXTENSION() {
        return CLASS_METADATA_FILE_EXTENSION;
    }

    @JvmStatic
    @NotNull
    public static final JsModuleDescriptor<PackageFragmentProvider> readModule(@NotNull byte[] metadata, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor kotlinModule) {
        Intrinsics.checkParameterIsNotNull(metadata, "metadata");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(kotlinModule, "kotlinModule");
        String string = kotlinModule.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "kotlinModule.name.asString()");
        JsModuleDescriptor jsModule = KotlinJavascriptSerializationUtilKt.access$readAsContentMap(metadata, string);
        return jsModule.copy(KotlinJavascriptSerializationUtil.createPackageFragmentProvider(kotlinModule, (Map)jsModule.getData(), storageManager));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    private static final PackageFragmentProvider createPackageFragmentProvider(ModuleDescriptor moduleDescriptor, Map<String, byte[]> contentMap, StorageManager storageManager) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = INSTANCE.getPackages(contentMap);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            void var9_9 = destination$iv$iv;
            FqName fqName2 = new FqName((String)it);
            var9_9.add(fqName2);
        }
        Set<FqName> packageFqNames = CollectionsKt.toSet((List)destination$iv$iv);
        if (packageFqNames.isEmpty()) {
            return null;
        }
        return KotlinJavascriptPackageFragmentProviderKt.createKotlinJavascriptPackageFragmentProvider(storageManager, moduleDescriptor, packageFqNames, (Function1<? super String, ? extends InputStream>)new Function1<String, InputStream>(contentMap){
            final /* synthetic */ Map $contentMap;

            @Nullable
            public final InputStream invoke(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull(path, "path");
                return !this.$contentMap.containsKey(path) ? (InputStream)(KotlinJavascriptSerializedResourcePathsKt.isPackageMetadataFile(path) ? new ByteArrayInputStream(KotlinJavascriptSerializationUtil.access$getPACKAGE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil.INSTANCE)) : (KotlinJavascriptSerializedResourcePathsKt.isStringTableFile(path) ? new ByteArrayInputStream(KotlinJavascriptSerializationUtil.access$getSTRING_TABLE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil.INSTANCE)) : (KotlinJavascriptSerializedResourcePathsKt.isClassesInPackageFile(path) ? new ByteArrayInputStream(KotlinJavascriptSerializationUtil.access$getCLASSES_IN_PACKAGE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil.INSTANCE)) : (ByteArrayInputStream)null))) : (InputStream)new ByteArrayInputStream((byte[])this.$contentMap.get(path));
            }
            {
                this.$contentMap = map2;
                super(1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] contentMapToByteArray(@NotNull Map<String, byte[]> contentMap, @NotNull ModuleKind moduleKind, @NotNull List<String> importedModules) {
        Object it;
        Map<String, byte[]> $receiver$iv;
        JsProtoBuf.Library.Kind kind;
        Intrinsics.checkParameterIsNotNull(contentMap, "contentMap");
        Intrinsics.checkParameterIsNotNull((Object)moduleKind, "moduleKind");
        Intrinsics.checkParameterIsNotNull(importedModules, "importedModules");
        JsProtoBuf.Library.Builder contentBuilder = JsProtoBuf.Library.newBuilder();
        switch (KotlinJavascriptSerializationUtil$WhenMappings.$EnumSwitchMapping$0[moduleKind.ordinal()]) {
            case 1: {
                kind = JsProtoBuf.Library.Kind.PLAIN;
                break;
            }
            case 2: {
                kind = JsProtoBuf.Library.Kind.AMD;
                break;
            }
            case 3: {
                kind = JsProtoBuf.Library.Kind.COMMON_JS;
                break;
            }
            case 4: {
                kind = JsProtoBuf.Library.Kind.UMD;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        contentBuilder.setKind(kind);
        Iterable iterable = importedModules;
        Object object = $receiver$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            it = (String)element$iv;
            contentBuilder.addImportedModule((String)it);
        }
        $receiver$iv = contentMap;
        object = $receiver$iv;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = iterator2.next();
            JsProtoBuf.Library.FileEntry entry = JsProtoBuf.Library.FileEntry.newBuilder().setPath((String)it2.getKey()).setContent(ByteString.copyFrom((byte[])it2.getValue())).build();
            contentBuilder.addEntry(entry);
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        object = new GZIPOutputStream(byteStream);
        boolean bl = false;
        try {
            it = (GZIPOutputStream)object;
            contentBuilder.build().writeTo((OutputStream)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            bl = true;
            try {
                object.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                object.close();
            }
        }
        byte[] byArray = byteStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "byteStream.toByteArray()");
        return byArray;
    }

    @NotNull
    public final String metadataAsString(@NotNull JsModuleDescriptor<? extends ModuleDescriptor> jsDescriptor) {
        Intrinsics.checkParameterIsNotNull(jsDescriptor, "jsDescriptor");
        return KotlinJavascriptMetadataUtils.INSTANCE.formatMetadataAsString(jsDescriptor.getName(), this.toBinaryMetadata(jsDescriptor));
    }

    public final void serializePackage(@NotNull ModuleDescriptor module, @NotNull FqName fqName2, @NotNull Function2<? super String, ? super byte[], Unit> writeFun) {
        byte[] stringBytes;
        Intrinsics.checkParameterIsNotNull(module, "module");
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(writeFun, "writeFun");
        PackageViewDescriptor packageView = module.getPackage(fqName2);
        Function1 skip2 = new Function1<DeclarationDescriptor, Boolean>(module){
            final /* synthetic */ ModuleDescriptor $module;

            public final boolean invoke(@NotNull DeclarationDescriptor it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return Intrinsics.areEqual(DescriptorUtils.getContainingModule(it), this.$module) ^ true;
            }
            {
                this.$module = moduleDescriptor;
                super(1);
            }
        };
        KotlinJavascriptSerializerExtension serializerExtension = new KotlinJavascriptSerializerExtension();
        DescriptorSerializer serializer = DescriptorSerializer.Companion.createTopLevel(serializerExtension);
        List classifierDescriptors = DescriptorSerializer.Companion.sort(ResolutionScope.DefaultImpls.getContributedDescriptors$default(packageView.getMemberScope(), DescriptorKindFilter.CLASSIFIERS, null, 2, null));
        ClassSerializationUtil.INSTANCE.serializeClasses(classifierDescriptors, serializer, new ClassSerializationUtil.Sink(writeFun){
            final /* synthetic */ Function2 $writeFun;

            public void writeClass(@NotNull ClassDescriptor classDescriptor, @NotNull ProtoBuf.Class classProto) {
                Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
                Intrinsics.checkParameterIsNotNull(classProto, "classProto");
                ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
                classProto.writeTo(stream2);
                String string = KotlinJavascriptSerializationUtil.access$getFileName(KotlinJavascriptSerializationUtil.INSTANCE, classDescriptor);
                byte[] byArray = stream2.toByteArray();
                Intrinsics.checkExpressionValueIsNotNull(byArray, "stream.toByteArray()");
                this.$writeFun.invoke(string, byArray);
            }
            {
                this.$writeFun = $captured_local_variable$0;
            }
        }, skip2);
        ByteArrayOutputStream packageStream = new ByteArrayOutputStream();
        List<PackageFragmentDescriptor> fragments2 = packageView.getFragments();
        ProtoBuf.Package package_ = serializer.packageProto((Collection<? extends PackageFragmentDescriptor>)fragments2, skip2).build();
        if (package_ == null) {
            String string = "Package fragments not serialized: " + fragments2;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ProtoBuf.Package packageProto = package_;
        if (packageProto.getFunctionCount() > 0 || packageProto.getPropertyCount() > 0) {
            packageProto.writeTo(packageStream);
            String string = KotlinJavascriptSerializedResourcePaths.INSTANCE.getPackageFilePath(fqName2);
            byte[] byArray = packageStream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "packageStream.toByteArray()");
            writeFun.invoke(string, (byte[])byArray);
        }
        StringTableImpl strings = serializerExtension.getStringTable();
        this.serializeClassNamesInPackage(fqName2, (Collection<? extends PackageFragmentDescriptor>)fragments2, strings, skip2, writeFun);
        ByteArrayOutputStream nameStream = new ByteArrayOutputStream();
        strings.serializeTo(nameStream);
        byte[] byArray = stringBytes = nameStream.toByteArray();
        if (!(byArray.length == 0) && !Arrays.equals(stringBytes, STRING_TABLE_DEFAULT_BYTES)) {
            String string = KotlinJavascriptSerializedResourcePaths.INSTANCE.getStringTableFilePath(fqName2);
            Intrinsics.checkExpressionValueIsNotNull(stringBytes, "stringBytes");
            writeFun.invoke(string, (byte[])stringBytes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void serializeClassNamesInPackage(FqName fqName2, Collection<? extends PackageFragmentDescriptor> packageFragments2, StringTableImpl stringTable, Function1<? super DeclarationDescriptor, Boolean> skip2, Function2<? super String, ? super byte[], Unit> writeFun) {
        Collection destination$iv$iv;
        ClassOrPackageFragmentDescriptor it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = packageFragments2;
        void var7_7 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void destination$iv$iv2;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            it = (PackageFragmentDescriptor)element$iv$iv;
            Iterable iterable2 = ResolutionScope.DefaultImpls.getContributedDescriptors$default(it.getMemberScope(), DescriptorKindFilter.CLASSIFIERS, null, 2, null);
            void var13_13 = $receiver$iv2;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                if (!(element$iv$iv2 instanceof ClassDescriptor)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ClassDescriptor)element$iv$iv;
            if (!(skip2.invoke(it) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classes2 = (List)destination$iv$iv;
        JsProtoBuf.Classes.Builder builder = JsProtoBuf.Classes.newBuilder();
        for (ClassDescriptor descriptor2 : DescriptorSerializer.Companion.sort(classes2)) {
            Name name = descriptor2.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
            builder.addClassName(stringTable.getSimpleNameIndex(name));
        }
        JsProtoBuf.Classes classesProto = builder.build();
        if (classesProto.getClassNameCount() > 0) {
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            classesProto.writeTo(stream2);
            String string = KotlinJavascriptSerializedResourcePaths.INSTANCE.getClassesInPackageFilePath(fqName2);
            byte[] byArray = stream2.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "stream.toByteArray()");
            writeFun.invoke(string, (byte[])byArray);
        }
    }

    private final String getFileName(ClassDescriptor classDescriptor) {
        return KotlinJavascriptSerializedResourcePaths.INSTANCE.getClassMetadataPath(DescriptorUtilsKt.getClassId(classDescriptor));
    }

    @NotNull
    public final Map<String, byte[]> toContentMap(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        HashMap contentMap = MapsKt.hashMapOf(new Pair[0]);
        Iterable $receiver$iv = this.getPackagesFqNames(module);
        for (Object element$iv : $receiver$iv) {
            FqName it = (FqName)element$iv;
            INSTANCE.serializePackage(module, it, (Function2<? super String, ? super byte[], Unit>)new Function2<String, byte[], Unit>(module, contentMap){
                final /* synthetic */ ModuleDescriptor $module$inlined;
                final /* synthetic */ HashMap $contentMap$inlined;

                public final void invoke(String fileName, byte[] bytes) {
                    Map map2 = this.$contentMap$inlined;
                    byte[] byArray = bytes;
                    map2.put(fileName, byArray);
                }
                {
                    this.$module$inlined = moduleDescriptor;
                    this.$contentMap$inlined = hashMap;
                    super(2);
                }
            });
        }
        return contentMap;
    }

    private final Set<FqName> getPackagesFqNames(ModuleDescriptor module) {
        HashSet<FqName> hashSet = new HashSet<FqName>();
        HashSet<FqName> $receiver = hashSet;
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqName.ROOT");
        INSTANCE.getSubPackagesFqNames(module.getPackage(fqName2), (Set<FqName>)$receiver);
        $receiver.add(FqName.ROOT);
        return hashSet;
    }

    private final void getSubPackagesFqNames(PackageViewDescriptor packageView, Set<FqName> result2) {
        FqName fqName2 = packageView.getFqName();
        if (!fqName2.isRoot()) {
            result2.add(fqName2);
        }
        for (DeclarationDescriptor descriptor2 : packageView.getMemberScope().getContributedDescriptors(DescriptorKindFilter.PACKAGES, MemberScope.Companion.getALL_NAME_FILTER())) {
            if (!(descriptor2 instanceof PackageViewDescriptor)) continue;
            this.getSubPackagesFqNames((PackageViewDescriptor)descriptor2, result2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getPackages(Map<String, byte[]> contentMap) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object element$iv2;
        Iterable $receiver$iv;
        String string;
        String it;
        void var8_8;
        Iterable destination$iv$iv2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2 = contentMap.keySet();
        Iterable iterable = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            String string2 = (String)item$iv$iv;
            var8_8 = destination$iv$iv2;
            string = StringsKt.substringBeforeLast$default(StringsKt.startsWith$default((CharSequence)it, '/', false, 2, null) ? it : "/" + it, '/', null, 2, null);
            var8_8.add(string);
        }
        Set keys = CollectionsKt.toSet((List)destination$iv$iv2);
        HashSet<String> result2 = SetsKt.hashSetOf(new String[0]);
        Function1<String, Unit> addNames$ = new Function1<String, Unit>(result2){
            final /* synthetic */ HashSet $result;

            public final void invoke(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull(name, "name");
                this.$result.add(name);
                if (Intrinsics.areEqual(name, "") ^ true) {
                    this.invoke(StringsKt.substringBeforeLast$default(name, '/', null, 2, null));
                }
            }
            {
                this.$result = hashSet;
                super(1);
            }
        };
        destination$iv$iv2 = keys;
        for (Object element$iv2 : $receiver$iv) {
            it = (String)element$iv2;
            addNames$.invoke(it);
        }
        $receiver$iv = result2;
        Iterable iterable2 = $receiver$iv;
        element$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            String $i$f$forEach = (String)item$iv$iv;
            var8_8 = destination$iv$iv;
            string = StringsKt.replace$default(StringsKt.substringAfter$default((String)it2, '/', null, 2, null), '/', '.', false, 4, null);
            var8_8.add(string);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    private final byte[] toBinaryMetadata(@NotNull JsModuleDescriptor<? extends ModuleDescriptor> $receiver) {
        return this.contentMapToByteArray(this.toContentMap($receiver.getData()), $receiver.getKind(), $receiver.getImported());
    }

    private KotlinJavascriptSerializationUtil() {
        INSTANCE = this;
        CLASS_METADATA_FILE_EXTENSION = CLASS_METADATA_FILE_EXTENSION;
        KotlinJavascriptSerializationUtil kotlinJavascriptSerializationUtil = this;
        KotlinJavascriptSerializationUtil $receiver = kotlinJavascriptSerializationUtil;
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        ProtoBuf.Package.getDefaultInstance().writeTo(stream2);
        PACKAGE_DEFAULT_BYTES = stream2.toByteArray();
        kotlinJavascriptSerializationUtil = this;
        $receiver = kotlinJavascriptSerializationUtil;
        stream2 = new ByteArrayOutputStream();
        JsProtoBuf.Classes.getDefaultInstance().writeTo(stream2);
        CLASSES_IN_PACKAGE_DEFAULT_BYTES = stream2.toByteArray();
        kotlinJavascriptSerializationUtil = this;
        $receiver = kotlinJavascriptSerializationUtil;
        DescriptorSerializer serializer = DescriptorSerializer.Companion.createTopLevel(new KotlinJavascriptSerializerExtension());
        ByteArrayOutputStream stream3 = new ByteArrayOutputStream();
        serializer.getStringTable().serializeTo(stream3);
        STRING_TABLE_DEFAULT_BYTES = stream3.toByteArray();
    }

    static {
        new KotlinJavascriptSerializationUtil();
    }

    public static final /* synthetic */ byte[] access$getPACKAGE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil $this) {
        KotlinJavascriptSerializationUtil kotlinJavascriptSerializationUtil = $this;
        return PACKAGE_DEFAULT_BYTES;
    }

    public static final /* synthetic */ byte[] access$getSTRING_TABLE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil $this) {
        KotlinJavascriptSerializationUtil kotlinJavascriptSerializationUtil = $this;
        return STRING_TABLE_DEFAULT_BYTES;
    }

    public static final /* synthetic */ byte[] access$getCLASSES_IN_PACKAGE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil $this) {
        KotlinJavascriptSerializationUtil kotlinJavascriptSerializationUtil = $this;
        return CLASSES_IN_PACKAGE_DEFAULT_BYTES;
    }

    @NotNull
    public static final /* synthetic */ String access$getFileName(KotlinJavascriptSerializationUtil $this, @NotNull ClassDescriptor classDescriptor) {
        return $this.getFileName(classDescriptor);
    }
}

