/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsImpl$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007J\u001e\u0010\u001b\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001a\u0010 \u001a\u00020\u00002\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u000b0\"J6\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010&\u001a\u00020'2\u0010\b\u0002\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010)H\u0002J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120%2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0006\u0010\u000e\u001a\u00020\u0019J \u0010,\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBoundsImpl;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;", "typeVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;)V", "bounds", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "getBounds", "()Ljava/util/ArrayList;", "<set-?>", "", "isFixed", "()Z", "setFixed", "(Z)V", "resultValues", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "getTypeVariable", "()Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "values", "getValues", "()Ljava/util/Collection;", "addBound", "", "bound", "checkOnlyInputTypes", "possibleAnswer", "commonSupertypeForNumberTypes", "numberLowerBounds", "computeValues", "filter", "condition", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "filterBounds", "", "kind", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "errorValues", "", "getIntersectionOfSupertypes", "types", "tryPossibleAnswer", "kotlin-compiler"})
public final class TypeBoundsImpl
implements TypeBounds {
    @NotNull
    private final ArrayList<TypeBounds.Bound> bounds;
    private Collection<? extends KotlinType> resultValues;
    private boolean isFixed;
    @NotNull
    private final TypeVariable typeVariable;

    @NotNull
    public ArrayList<TypeBounds.Bound> getBounds() {
        return this.bounds;
    }

    public final boolean isFixed() {
        return this.isFixed;
    }

    public final void setFixed() {
        this.isFixed = true;
    }

    public final void addBound(@NotNull TypeBounds.Bound bound) {
        Intrinsics.checkParameterIsNotNull(bound, "bound");
        this.resultValues = null;
        boolean bl = Intrinsics.areEqual(bound.getTypeVariable(), this.getTypeVariable());
        if (_Assertions.ENABLED && !bl) {
            String string = bound + " is added for incorrect type variable " + bound.getTypeVariable().getName() + ". Expected: " + this.getTypeVariable().getName();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ((ArrayList)this.getBounds()).add(bound);
    }

    private final Set<KotlinType> filterBounds(Collection<TypeBounds.Bound> bounds, TypeBounds.BoundKind kind, Collection<KotlinType> errorValues) {
        LinkedHashSet<KotlinType> result2 = new LinkedHashSet<KotlinType>();
        for (TypeBounds.Bound bound : bounds) {
            if (!Intrinsics.areEqual((Object)bound.getKind(), (Object)kind)) continue;
            if (!ErrorUtils.containsErrorType(bound.getConstrainingType())) {
                result2.add(bound.getConstrainingType());
                continue;
            }
            Collection<KotlinType> collection = errorValues;
            if (collection == null) continue;
            collection.add(bound.getConstrainingType());
        }
        return result2;
    }

    static /* bridge */ /* synthetic */ Set filterBounds$default(TypeBoundsImpl typeBoundsImpl, Collection collection, TypeBounds.BoundKind boundKind, Collection collection2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: filterBounds");
        }
        if ((n & 4) != 0) {
            collection2 = null;
        }
        return typeBoundsImpl.filterBounds(collection, boundKind, collection2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeBoundsImpl filter(@NotNull Function1<? super ConstraintPosition, Boolean> condition) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        TypeBoundsImpl result2 = new TypeBoundsImpl(this.getTypeVariable());
        Iterable iterable = this.getBounds();
        Collection collection = result2.getBounds();
        void var5_5 = $receiver$iv;
        Collection collection2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeBounds.Bound it = (TypeBounds.Bound)element$iv$iv;
            if (!condition.invoke(it.getPosition()).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        ((ArrayList)collection).addAll(list2);
        return result2;
    }

    @Override
    @NotNull
    public Collection<KotlinType> getValues() {
        if (this.resultValues == null) {
            this.resultValues = this.computeValues();
        }
        Collection<KotlinType> collection = this.resultValues;
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KotlinType> computeValues() {
        KotlinType intersectionOfUpperBounds;
        KotlinType superTypeOfAllLowerBounds;
        void numberLowerBounds;
        void generalLowerBounds;
        void $receiver$iv;
        boolean hasStrongBound;
        Object it;
        Object element$iv2;
        List bounds;
        LinkedHashSet values;
        block15: {
            boolean bl;
            Iterator destination$iv$iv;
            void $receiver$iv$iv;
            values = new LinkedHashSet();
            Iterable $receiver$iv2 = this.getBounds();
            Iterable iterable = $receiver$iv2;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                TypeBounds.Bound it2 = (TypeBounds.Bound)element$iv$iv;
                if (!it2.isProper()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            bounds = (List)((Object)destination$iv$iv);
            if (bounds.isEmpty()) {
                return kotlin.collections.CollectionsKt.emptyList();
            }
            Iterable $receiver$iv3 = bounds;
            for (Object element$iv2 : $receiver$iv3) {
                it = (TypeBounds.Bound)element$iv2;
                if (!((TypeBounds.Bound)it).getPosition().isStrong()) continue;
                bl = true;
                break block15;
            }
            bl = hasStrongBound = false;
        }
        if (!hasStrongBound) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        Set<KotlinType> exactBounds = this.filterBounds(bounds, TypeBounds.BoundKind.EXACT_BOUND, values);
        KotlinType bestFit = FlexibleTypesKt.singleBestRepresentative((Collection<? extends KotlinType>)exactBounds);
        if (bestFit != null && this.tryPossibleAnswer(bounds, bestFit)) {
            return kotlin.collections.CollectionsKt.listOf(bestFit);
        }
        values.addAll(exactBounds);
        Iterable $i$f$any = this.filterBounds(bounds, TypeBounds.BoundKind.LOWER_BOUND, values);
        ArrayList first$iv = new ArrayList();
        Collection second$iv = new ArrayList();
        for (Object element$iv3 : $receiver$iv) {
            KotlinType it3 = (KotlinType)element$iv3;
            if (it3.getConstructor() instanceof IntegerValueTypeConstructor) {
                first$iv.add(element$iv3);
                continue;
            }
            ((ArrayList)second$iv).add(element$iv3);
        }
        Pair $i$a$1$any = new Pair(first$iv, second$iv);
        element$iv2 = $i$a$1$any.component1();
        it = $i$a$1$any.component2();
        $i$a$1$any = null;
        KotlinType superTypeOfLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection)generalLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfLowerBounds)) {
            KotlinType kotlinType = superTypeOfLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf(kotlinType);
        }
        CollectionsKt.addIfNotNull(values, superTypeOfLowerBounds);
        KotlinType superTypeOfNumberLowerBounds = this.commonSupertypeForNumberTypes((Collection)numberLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfNumberLowerBounds)) {
            KotlinType kotlinType = superTypeOfNumberLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf(kotlinType);
        }
        CollectionsKt.addIfNotNull(values, superTypeOfNumberLowerBounds);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && this.tryPossibleAnswer(bounds, superTypeOfAllLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection<KotlinType>)kotlin.collections.CollectionsKt.listOf(new KotlinType[]{superTypeOfLowerBounds, superTypeOfNumberLowerBounds})))) {
            KotlinType kotlinType = superTypeOfAllLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf(kotlinType);
        }
        Set<KotlinType> upperBounds = this.filterBounds(bounds, TypeBounds.BoundKind.UPPER_BOUND, values);
        second$iv = upperBounds;
        if (!second$iv.isEmpty() && (intersectionOfUpperBounds = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, (Collection<KotlinType>)upperBounds)) != null && this.tryPossibleAnswer(bounds, intersectionOfUpperBounds)) {
            return SetsKt.setOf(intersectionOfUpperBounds);
        }
        values.addAll(TypeBoundsImpl.filterBounds$default(this, bounds, TypeBounds.BoundKind.UPPER_BOUND, null, 4, null));
        if (values.size() == 1 && this.getTypeVariable().hasOnlyInputTypesAnnotation() && !this.tryPossibleAnswer(bounds, (KotlinType)kotlin.collections.CollectionsKt.first(values))) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        return values;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkOnlyInputTypes(Collection<TypeBounds.Bound> bounds, KotlinType possibleAnswer) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        boolean bl;
        Object it;
        Object element$iv2;
        Object $receiver$iv$iv2;
        block6: {
            Collection destination$iv$iv2;
            TypeBounds.Bound it2;
            if (!this.getTypeVariable().hasOnlyInputTypesAnnotation()) {
                return true;
            }
            Iterable $receiver$iv2 = bounds;
            Iterable iterable = $receiver$iv2;
            Collection collection = new ArrayList();
            Iterator iterator2 = $receiver$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                it2 = (TypeBounds.Bound)element$iv$iv;
                if (!(it2.isProper() && it2.getConstrainingType().getConstructor().isDenotable())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            $receiver$iv$iv2 = $receiver$iv2;
            destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            iterator2 = $receiver$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                it2 = (TypeBounds.Bound)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                KotlinType kotlinType = it2.getConstrainingType();
                collection2.add(kotlinType);
            }
            Set typesInBoundsSet = kotlin.collections.CollectionsKt.toSet((List)destination$iv$iv2);
            $receiver$iv2 = typesInBoundsSet;
            for (Object element$iv2 : $receiver$iv2) {
                it = (KotlinType)element$iv2;
                if (!KotlinTypeChecker.DEFAULT.equalTypes((KotlinType)it, possibleAnswer)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        $receiver$iv$iv2 = TypeBoundsImpl.filterBounds$default(this, bounds, TypeBounds.BoundKind.LOWER_BOUND, null, 4, null);
        element$iv2 = $receiver$iv;
        it = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KotlinType it3 = (KotlinType)element$iv$iv;
            if (!(it3.getConstructor() instanceof IntegerValueTypeConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List numberLowerBounds = (List)destination$iv$iv;
        KotlinType superTypeOfNumberLowerBounds = this.commonSupertypeForNumberTypes(numberLowerBounds);
        return Intrinsics.areEqual(possibleAnswer, superTypeOfNumberLowerBounds);
    }

    private final boolean tryPossibleAnswer(Collection<TypeBounds.Bound> bounds, KotlinType possibleAnswer) {
        if (possibleAnswer == null) {
            return false;
        }
        if (!possibleAnswer.getConstructor().isDenotable() && !CapturedTypeConstructorKt.isCaptured(possibleAnswer)) {
            return false;
        }
        if (!this.checkOnlyInputTypes(bounds, possibleAnswer)) {
            return false;
        }
        block5: for (TypeBounds.Bound bound : bounds) {
            switch (TypeBoundsImpl$WhenMappings.$EnumSwitchMapping$0[bound.getKind().ordinal()]) {
                case 1: {
                    if (KotlinTypeChecker.DEFAULT.isSubtypeOf(bound.getConstrainingType(), possibleAnswer)) continue block5;
                    return false;
                }
                case 2: {
                    if (KotlinTypeChecker.DEFAULT.isSubtypeOf(possibleAnswer, bound.getConstrainingType())) continue block5;
                    return false;
                }
                case 3: {
                    if (KotlinTypeChecker.DEFAULT.equalTypes(bound.getConstrainingType(), possibleAnswer)) break;
                    return false;
                }
            }
        }
        return true;
    }

    private final KotlinType commonSupertypeForNumberTypes(Collection<? extends KotlinType> numberLowerBounds) {
        if (numberLowerBounds.isEmpty()) {
            return null;
        }
        Set<KotlinType> intersectionOfSupertypes = this.getIntersectionOfSupertypes(numberLowerBounds);
        KotlinType kotlinType = TypeUtils.getDefaultPrimitiveNumberType((Collection<KotlinType>)intersectionOfSupertypes);
        if (kotlinType == null) {
            kotlinType = CommonSupertypes.commonSupertype(numberLowerBounds);
        }
        return kotlinType;
    }

    private final Set<KotlinType> getIntersectionOfSupertypes(Collection<? extends KotlinType> types) {
        HashSet<KotlinType> upperBounds = new HashSet<KotlinType>();
        for (KotlinType kotlinType : types) {
            Collection<KotlinType> supertypes2 = kotlinType.getConstructor().getSupertypes();
            if (upperBounds.isEmpty()) {
                upperBounds.addAll(supertypes2);
                continue;
            }
            Collection<KotlinType> collection = supertypes2;
            Intrinsics.checkExpressionValueIsNotNull(collection, "supertypes");
            upperBounds.retainAll(collection);
        }
        return upperBounds;
    }

    @Override
    @NotNull
    public TypeVariable getTypeVariable() {
        return this.typeVariable;
    }

    public TypeBoundsImpl(@NotNull TypeVariable typeVariable) {
        Intrinsics.checkParameterIsNotNull(typeVariable, "typeVariable");
        this.typeVariable = typeVariable;
        this.bounds = new ArrayList();
    }

    @Override
    @Nullable
    public KotlinType getValue() {
        return TypeBounds.DefaultImpls.getValue(this);
    }
}

