/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import java.util.Collection;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClassMarker;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaConstructor;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.LightClassOriginKind;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassifierImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

public class JavaClassImpl
extends JavaClassifierImpl<PsiClass>
implements JavaClass,
JavaAnnotationOwnerImpl,
JavaModifierListOwnerImpl {
    public JavaClassImpl(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "<init>"));
        }
        super(psiClass);
        assert (!(psiClass instanceof PsiTypeParameter)) : "PsiTypeParameter should be wrapped in JavaTypeParameter, not JavaClass: use JavaClassifier.create()";
    }

    @Override
    @NotNull
    public Collection<JavaClass> getInnerClasses() {
        Collection<JavaClass> collection = JavaElementCollectionFromPsiArrayUtil.classes(((PsiClass)this.getPsi()).getInnerClasses());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getInnerClasses"));
        }
        return collection;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        String qualifiedName = ((PsiClass)this.getPsi()).getQualifiedName();
        return qualifiedName == null ? null : new FqName(qualifiedName);
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = SpecialNames.safeIdentifier(((PsiClass)this.getPsi()).getName());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getName"));
        }
        return name;
    }

    @Override
    public boolean isInterface() {
        return ((PsiClass)this.getPsi()).isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return ((PsiClass)this.getPsi()).isAnnotationType();
    }

    @Override
    public boolean isEnum() {
        return ((PsiClass)this.getPsi()).isEnum();
    }

    @Override
    @Nullable
    public JavaClassImpl getOuterClass() {
        PsiClass outer = ((PsiClass)this.getPsi()).getContainingClass();
        return outer == null ? null : new JavaClassImpl(outer);
    }

    @Override
    @NotNull
    public List<JavaTypeParameter> getTypeParameters() {
        List<JavaTypeParameter> list2 = JavaElementCollectionFromPsiArrayUtil.typeParameters(((PsiClass)this.getPsi()).getTypeParameters());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getTypeParameters"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        Collection<JavaClassifierType> collection = JavaElementCollectionFromPsiArrayUtil.classifierTypes(((PsiClass)this.getPsi()).getSuperTypes());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getSupertypes"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JavaMethod> getMethods() {
        List<JavaMethod> list2 = CollectionsKt.distinct(JavaElementCollectionFromPsiArrayUtil.methods(ArraysKt.filter(((PsiClass)this.getPsi()).getMethods(), new Function1<PsiMethod, Boolean>(){

            @Override
            public Boolean invoke(PsiMethod method) {
                return !method.isConstructor() && method.getReturnType() != null;
            }
        })));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getMethods"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<JavaField> getFields() {
        Collection<JavaField> collection = JavaElementCollectionFromPsiArrayUtil.fields(ArraysKt.filter(((PsiClass)this.getPsi()).getFields(), new Function1<PsiField, Boolean>(){

            @Override
            public Boolean invoke(PsiField field) {
                String name = field.getName();
                return name != null && Name.isValidIdentifier(name);
            }
        }));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getFields"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JavaConstructor> getConstructors() {
        Collection<JavaConstructor> collection = JavaElementCollectionFromPsiArrayUtil.constructors(ArraysKt.filter(((PsiClass)this.getPsi()).getConstructors(), new Function1<PsiMethod, Boolean>(){

            @Override
            public Boolean invoke(PsiMethod method) {
                return method.isConstructor();
            }
        }));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getConstructors"));
        }
        return collection;
    }

    @Override
    public boolean isAbstract() {
        return JavaElementUtil.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return JavaElementUtil.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return JavaElementUtil.isFinal(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = JavaElementUtil.getVisibility(this);
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @Nullable
    public LightClassOriginKind getLightClassOriginKind() {
        PsiClass psiClass = (PsiClass)this.getPsi();
        if (psiClass instanceof KtLightClassMarker) {
            return ((KtLightClassMarker)((Object)psiClass)).getOriginKind();
        }
        return null;
    }

    @Override
    @Nullable
    public PsiAnnotationOwner getAnnotationOwnerPsi() {
        return ((PsiClass)this.getPsi()).getModifierList();
    }
}

