/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001aH\u0010\r\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u000e\u0012\u0004\u0012\u0002H\u00110\u000f0\u000e\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00100\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u0013\u00a8\u0006\u0014"}, d2={"generateDelegateCall", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsPropertyInitializer;", "fromDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "toDescriptor", "thisObject", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "getReferenceToJsClass", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsNameRef;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "splitToRanges", "", "Lkotlin/Pair;", "T", "S", "classifier", "Lkotlin/Function1;", "kotlin-compiler"})
public final class UtilsKt {
    @NotNull
    public static final JsPropertyInitializer generateDelegateCall(@NotNull FunctionDescriptor fromDescriptor, @NotNull FunctionDescriptor toDescriptor, @NotNull JsExpression thisObject, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(fromDescriptor, "fromDescriptor");
        Intrinsics.checkParameterIsNotNull(toDescriptor, "toDescriptor");
        Intrinsics.checkParameterIsNotNull(thisObject, "thisObject");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsName delegateMemberFunctionName = context.getNameForDescriptor(fromDescriptor);
        JsName overriddenMemberFunctionName = context.getNameForDescriptor(toDescriptor);
        JsNameRef overriddenMemberFunctionRef = new JsNameRef(overriddenMemberFunctionName, thisObject);
        SmartList<JsParameter> parameters2 = new SmartList<JsParameter>();
        SmartList<JsNameRef> args = new SmartList<JsNameRef>();
        JsScope functionScope = context.getScopeForDescriptor(fromDescriptor);
        if (DescriptorUtils.isExtension(fromDescriptor)) {
            JsName extensionFunctionReceiverName = functionScope.declareName(Namer.getReceiverParameterName());
            parameters2.add(new JsParameter(extensionFunctionReceiverName));
            args.add(new JsNameRef(extensionFunctionReceiverName));
        }
        for (ValueParameterDescriptor param : fromDescriptor.getValueParameters()) {
            String paramName = param.getName().asString();
            JsName jsParamName = functionScope.declareName(paramName);
            parameters2.add(new JsParameter(jsParamName));
            args.add(new JsNameRef(jsParamName));
        }
        JsFunction functionObject = TranslationUtils.simpleReturnFunction(context.getScopeForDescriptor(fromDescriptor), new JsInvocation((JsExpression)overriddenMemberFunctionRef, (List<JsExpression>)args));
        functionObject.getParameters().addAll((Collection<JsParameter>)parameters2);
        return new JsPropertyInitializer(delegateMemberFunctionName.makeRef(), functionObject);
    }

    @NotNull
    public static final <T, S> List<Pair<List<T>, S>> splitToRanges(@NotNull List<? extends T> $receiver, @NotNull Function1<? super T, ? extends S> classifier2) {
        Object object;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(classifier2, "classifier");
        if ($receiver.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int lastIndex = 0;
        S lastClass = classifier2.invoke($receiver.get(0));
        List<Pair<List<T>, S>> result2 = CollectionsKt.mutableListOf(new Pair[0]);
        Object object2 = SequencesKt.drop(SequencesKt.withIndex(CollectionsKt.asSequence((Iterable)$receiver)), 1).iterator();
        while (object2.hasNext()) {
            object = object2.next();
            int index2 = ((IndexedValue)object).component1();
            Object e = ((IndexedValue)object).component2();
            S cls = classifier2.invoke(e);
            if (!(Intrinsics.areEqual(cls, lastClass) ^ true)) continue;
            Collection collection = result2;
            Pair<List<? extends T>, S> pair = new Pair<List<? extends T>, S>($receiver.subList(lastIndex, index2), lastClass);
            collection.add(pair);
            lastClass = cls;
            lastIndex = index2;
        }
        object = result2;
        object2 = new Pair<List<? extends T>, S>($receiver.subList(lastIndex, $receiver.size()), lastClass);
        object.add(object2);
        return result2;
    }

    @NotNull
    public static final JsNameRef getReferenceToJsClass(@NotNull KotlinType type2, @NotNull TranslationContext context) {
        JsNameRef referenceToJsClass;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor instanceof ClassDescriptor) {
            JsNameRef reference = context.getQualifiedReference(classifierDescriptor);
            if (Intrinsics.areEqual((Object)((ClassDescriptor)classifierDescriptor).getKind(), (Object)ClassKind.OBJECT)) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("constructor", (JsExpression)new JsInvocation((JsExpression)new JsNameRef("getPrototypeOf", (JsExpression)new JsNameRef("Object")), reference));
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "JsAstUtils.pureFqn(\"cons\u2026f(\"Object\")), reference))");
                referenceToJsClass = jsNameRef;
            } else {
                JsNameRef jsNameRef = reference;
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "reference");
                referenceToJsClass = jsNameRef;
            }
        } else if (classifierDescriptor instanceof TypeParameterDescriptor) {
            boolean bl = ((TypeParameterDescriptor)classifierDescriptor).isReified();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            JsNameRef jsNameRef = context.getNameForDescriptor(classifierDescriptor).makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getNameForDescri\u2026fierDescriptor).makeRef()");
            referenceToJsClass = jsNameRef;
        } else {
            throw (Throwable)new IllegalStateException("Can't get reference for " + type2);
        }
        return referenceToJsClass;
    }
}

