/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.types.KotlinType;

public final class StringTemplateTranslator
extends AbstractTranslator {
    private final KtStringTemplateEntry[] expressionEntries;

    @NotNull
    public static JsExpression translate(@NotNull KtStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator", "translate"));
        }
        JsExpression jsExpression = new StringTemplateTranslator(expression, context).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator", "translate"));
        }
        return jsExpression;
    }

    private StringTemplateTranslator(@NotNull KtStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator", "<init>"));
        }
        super(context);
        this.expressionEntries = expression.getEntries();
        assert (this.expressionEntries.length != 0) : ErrorReportingUtils.message(expression, "String template must have one or more entries.");
    }

    @NotNull
    private JsExpression translate() {
        EntryVisitor entryVisitor = new EntryVisitor();
        for (KtStringTemplateEntry entry : this.expressionEntries) {
            entry.accept(entryVisitor);
        }
        JsExpression jsExpression = entryVisitor.getResultingExpression();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator", "translate"));
        }
        return jsExpression;
    }

    private final class EntryVisitor
    extends KtVisitorVoid {
        @Nullable
        private JsExpression resultingExpression = null;

        private EntryVisitor() {
        }

        void append(@NotNull JsExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator$EntryVisitor", "append"));
            }
            this.resultingExpression = this.resultingExpression == null ? expression : JsAstUtils.sum(this.resultingExpression, expression);
        }

        @Override
        public void visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator$EntryVisitor", "visitStringTemplateEntryWithExpression"));
            }
            KtExpression entryExpression = entry.getExpression();
            assert (entryExpression != null) : "JetStringTemplateEntryWithExpression must have not null entry expression.";
            JsExpression translatedExpression = Translation.translateAsExpression(entryExpression, StringTemplateTranslator.this.context());
            if (translatedExpression instanceof JsNumberLiteral) {
                this.append(StringTemplateTranslator.this.context().program().getStringLiteral(translatedExpression.toString()));
                return;
            }
            KotlinType type2 = StringTemplateTranslator.this.context().bindingContext().getType(entryExpression);
            if (type2 == null || type2.isMarkedNullable()) {
                this.append(TopLevelFIF.TO_STRING.apply((JsExpression)null, Collections.singletonList(translatedExpression), StringTemplateTranslator.this.context()));
            } else if (this.mustCallToString(type2)) {
                this.append(new JsInvocation((JsExpression)new JsNameRef("toString", translatedExpression), new JsExpression[0]));
            } else {
                this.append(translatedExpression);
            }
        }

        private boolean mustCallToString(@NotNull KotlinType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator$EntryVisitor", "mustCallToString"));
            }
            Name typeName = DescriptorUtilsKt.getNameIfStandardType(type2);
            if (typeName != null) {
                if (NamePredicate.STRING.apply(typeName)) {
                    return false;
                }
                if (NamePredicate.PRIMITIVE_NUMBERS.apply(typeName)) {
                    return this.resultingExpression == null;
                }
            }
            return StringTemplateTranslator.this.expressionEntries.length == 1;
        }

        @Override
        public void visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator$EntryVisitor", "visitLiteralStringTemplateEntry"));
            }
            this.appendText(entry.getText());
        }

        @Override
        public void visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator$EntryVisitor", "visitEscapeStringTemplateEntry"));
            }
            this.appendText(entry.getUnescapedValue());
        }

        private void appendText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator$EntryVisitor", "appendText"));
            }
            this.append(StringTemplateTranslator.this.program().getStringLiteral(text));
        }

        @NotNull
        public JsExpression getResultingExpression() {
            assert (this.resultingExpression != null);
            JsExpression jsExpression = this.resultingExpression;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator$EntryVisitor", "getResultingExpression"));
            }
            return jsExpression;
        }
    }
}

