/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.descriptorUtils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\b*\u00020\n\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000b"}, d2={"nameIfStandardType", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getNameIfStandardType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/name/Name;", "getJetTypeFqName", "", "printTypeArguments", "", "hasPrimaryConstructor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin-compiler"})
public final class DescriptorUtilsKt {
    @Nullable
    public static final Name getNameIfStandardType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null && (classifierDescriptor = AddToStdlibKt.check(classifierDescriptor, nameIfStandardType.1.INSTANCE)) != null ? classifierDescriptor.getName() : null;
    }

    @NotNull
    public static final String getJetTypeFqName(@NotNull KotlinType $receiver, boolean printTypeArguments) {
        String typeArgumentsAsString;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ClassifierDescriptor declaration = classifierDescriptor;
        if (declaration instanceof TypeParameterDescriptor) {
            String string = StringUtil.join((Collection)((TypeParameterDescriptor)declaration).getUpperBounds(), (Function)new Function<T, String>(printTypeArguments){
                final /* synthetic */ boolean $printTypeArguments;

                @NotNull
                public final String fun(KotlinType type2) {
                    return DescriptorUtilsKt.getJetTypeFqName(type2, this.$printTypeArguments);
                }
                {
                    this.$printTypeArguments = bl;
                }
            }, "&");
            Intrinsics.checkExpressionValueIsNotNull(string, "StringUtil.join(declarat\u2026intTypeArguments) }, \"&\")");
            return string;
        }
        List<TypeProjection> typeArguments2 = $receiver.getArguments();
        if (printTypeArguments && !typeArguments2.isEmpty()) {
            String joinedTypeArguments2 = StringUtil.join((Collection)typeArguments2, (Function)getJetTypeFqName.joinedTypeArguments.1.INSTANCE, ", ");
            typeArgumentsAsString = "<" + joinedTypeArguments2 + ">";
        } else {
            typeArgumentsAsString = "";
        }
        return DescriptorUtils.getFqName(declaration).asString() + typeArgumentsAsString;
    }

    public static final boolean hasPrimaryConstructor(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getUnsubstitutedPrimaryConstructor() != null;
    }
}

