/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.io.ByteBufferWrapper;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public abstract class DirectBufferWrapper
extends ByteBufferWrapper {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.DirectBufferWrapper");
    private volatile ByteBuffer myBuffer;

    protected DirectBufferWrapper(File file, long offset2, long length) {
        super(file, offset2, length);
    }

    @Override
    public ByteBuffer getCachedBuffer() {
        return this.myBuffer;
    }

    @Override
    public ByteBuffer getBuffer() throws IOException {
        ByteBuffer buffer = this.myBuffer;
        if (buffer == null) {
            this.myBuffer = buffer = this.create();
        }
        return buffer;
    }

    protected abstract ByteBuffer create() throws IOException;

    @Override
    public void unmap() {
        if (this.isDirty()) {
            this.flush();
        }
        if (this.myBuffer != null) {
            DirectBufferWrapper.disposeDirectBuffer(this.myBuffer);
        }
        this.myBuffer = null;
    }

    static boolean disposeDirectBuffer(final ByteBuffer buffer) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            @Nullable
            public Object run() {
                try {
                    Cleaner cleaner;
                    if (buffer instanceof DirectBuffer && (cleaner = ((DirectBuffer)((Object)buffer)).cleaner()) != null) {
                        cleaner.clean();
                    }
                    return null;
                }
                catch (Throwable e) {
                    return buffer;
                }
            }
        }) == null;
    }
}

