/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;

public class PsiWildcardType
extends PsiType.Stub {
    public static final String EXTENDS_PREFIX = "? extends ";
    public static final String SUPER_PREFIX = "? super ";
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiWildcardType");
    private static final Key<PsiWildcardType> UNBOUNDED_WILDCARD = new Key("UNBOUNDED_WILDCARD");
    private final PsiManager myManager;
    private final boolean myIsExtending;
    private final PsiType myBound;

    private PsiWildcardType(@NotNull PsiManager manager, boolean isExtending, @Nullable PsiType bound) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "<init>"));
        }
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myManager = manager;
        this.myIsExtending = isExtending;
        this.myBound = bound;
    }

    private PsiWildcardType(@NotNull PsiWildcardType type2, @NotNull TypeAnnotationProvider annotations2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "<init>"));
        }
        super(annotations2);
        this.myManager = type2.myManager;
        this.myIsExtending = type2.myIsExtending;
        this.myBound = type2.myBound;
    }

    @NotNull
    public static PsiWildcardType createUnbounded(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "createUnbounded"));
        }
        PsiWildcardType unboundedWildcard = manager.getUserData(UNBOUNDED_WILDCARD);
        if (unboundedWildcard == null) {
            unboundedWildcard = manager.putUserDataIfAbsent(UNBOUNDED_WILDCARD, new PsiWildcardType(manager, false, null));
        }
        PsiWildcardType psiWildcardType = unboundedWildcard;
        if (psiWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "createUnbounded"));
        }
        return psiWildcardType;
    }

    @NotNull
    public static PsiWildcardType createExtends(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "createExtends"));
        }
        if (bound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bound", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "createExtends"));
        }
        LOG.assertTrue(!(bound instanceof PsiWildcardType));
        LOG.assertTrue(bound != PsiType.NULL);
        PsiWildcardType psiWildcardType = new PsiWildcardType(manager, true, bound);
        if (psiWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "createExtends"));
        }
        return psiWildcardType;
    }

    @NotNull
    public static PsiWildcardType createSuper(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "createSuper"));
        }
        if (bound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bound", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "createSuper"));
        }
        LOG.assertTrue(!(bound instanceof PsiWildcardType));
        LOG.assertTrue(bound != PsiType.NULL);
        PsiWildcardType psiWildcardType = new PsiWildcardType(manager, false, bound);
        if (psiWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "createSuper"));
        }
        return psiWildcardType;
    }

    @NotNull
    public PsiWildcardType annotate(final @NotNull PsiAnnotation[] annotations2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "annotate"));
        }
        PsiWildcardType psiWildcardType = annotations2.length == 0 ? this : new PsiWildcardType(this, new TypeAnnotationProvider(){

            @Override
            @NotNull
            public PsiAnnotation[] getAnnotations() {
                if (annotations2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType$1", "getAnnotations"));
                }
                return annotations2;
            }
        });
        if (psiWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "annotate"));
        }
        return psiWildcardType;
    }

    @NotNull
    public PsiWildcardType annotate(@NotNull TypeAnnotationProvider annotations2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "annotate"));
        }
        PsiWildcardType psiWildcardType = new PsiWildcardType(this, annotations2);
        if (psiWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "annotate"));
        }
        return psiWildcardType;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = this.getText(false, true, this.myBound == null ? null : this.myBound.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(true, annotated, this.myBound == null ? null : this.myBound.getCanonicalText(annotated));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getText(true, true, this.myBound == null ? null : this.myBound.getInternalCanonicalText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "getInternalCanonicalText"));
        }
        return string;
    }

    private String getText(boolean qualified, boolean annotated, @Nullable String suffix) {
        PsiAnnotation[] annotations2 = this.getAnnotations();
        if (!(annotated && annotations2.length != 0 || suffix != null)) {
            return "?";
        }
        StringBuilder sb = new StringBuilder();
        if (annotated) {
            PsiNameHelper.appendAnnotations(sb, annotations2, qualified);
        }
        if (suffix == null) {
            sb.append('?');
        } else {
            sb.append(this.myIsExtending ? EXTENDS_PREFIX : SUPER_PREFIX);
            sb.append(suffix);
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope scope;
        if (this.myBound != null && (scope = this.myBound.getResolveScope()) != null) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "getResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.myManager.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{this.getExtendsBound()};
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "getSuperTypes"));
        }
        return psiTypeArray;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "equalsToText"));
        }
        if (this.myBound == null) {
            return "?".equals(text);
        }
        if (this.myIsExtending) {
            return text.startsWith(EXTENDS_PREFIX) && this.myBound.equalsToText(text.substring(EXTENDS_PREFIX.length()));
        }
        return text.startsWith(SUPER_PREFIX) && this.myBound.equalsToText(text.substring(SUPER_PREFIX.length()));
    }

    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "getManager"));
        }
        return psiManager;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PsiWildcardType)) {
            return false;
        }
        PsiWildcardType that = (PsiWildcardType)o;
        if (this.myBound == null && that.myBound != null) {
            return that.isExtends() && that.myBound.equalsToText("java.lang.Object");
        }
        if (this.myBound != null && that.myBound == null) {
            return this.isExtends() && this.myBound.equalsToText("java.lang.Object");
        }
        return this.myIsExtending == that.myIsExtending && Comparing.equal(this.myBound, that.myBound);
    }

    public int hashCode() {
        return (this.myIsExtending ? 1 : 0) + (this.myBound != null ? this.myBound.hashCode() : 0);
    }

    @Nullable
    public PsiType getBound() {
        return this.myBound;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "accept"));
        }
        return visitor2.visitWildcardType(this);
    }

    @Override
    public boolean isValid() {
        return this.myBound == null || this.myBound.isValid();
    }

    public boolean isExtends() {
        return this.myBound != null && this.myIsExtending;
    }

    public boolean isSuper() {
        return this.myBound != null && !this.myIsExtending;
    }

    public boolean isBounded() {
        return this.myBound != null;
    }

    @NotNull
    public PsiType getExtendsBound() {
        if (this.myBound == null || !this.myIsExtending) {
            PsiClassType psiClassType = PsiWildcardType.getJavaLangObject(this.myManager, this.getResolveScope());
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "getExtendsBound"));
            }
            return psiClassType;
        }
        PsiType psiType = this.myBound;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "getExtendsBound"));
        }
        return psiType;
    }

    @NotNull
    public PsiType getSuperBound() {
        PsiType psiType = this.myBound == null || this.myIsExtending ? NULL : this.myBound;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType", "getSuperBound"));
        }
        return psiType;
    }
}

