/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageExtension;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.JVMElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.JVMElementFactoryProvider;

public class JVMElementFactories
extends LanguageExtension<JVMElementFactoryProvider> {
    private static final JVMElementFactories INSTANCE = new JVMElementFactories();

    private JVMElementFactories() {
        super("org.jetbrains.kotlin.com.intellij.generation.topLevelFactory");
    }

    @Nullable
    public static JVMElementFactory getFactory(@NotNull Language language, @NotNull Project project) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/JVMElementFactories", "getFactory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/JVMElementFactories", "getFactory"));
        }
        JVMElementFactoryProvider provider = (JVMElementFactoryProvider)INSTANCE.forLanguage(language);
        return provider != null ? provider.getFactory(project) : null;
    }

    @NotNull
    public static JVMElementFactory requireFactory(@NotNull Language language, @NotNull Project project) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/JVMElementFactories", "requireFactory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/JVMElementFactories", "requireFactory"));
        }
        JVMElementFactory factory = JVMElementFactories.getFactory(language, project);
        assert (factory != null) : language;
        JVMElementFactory jVMElementFactory = factory;
        if (jVMElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/JVMElementFactories", "requireFactory"));
        }
        return jVMElementFactory;
    }
}

