/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.ElementManipulator;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public abstract class AbstractElementManipulator<T extends PsiElement>
implements ElementManipulator<T> {
    @Override
    public T handleContentChange(@NotNull T element, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/AbstractElementManipulator", "handleContentChange"));
        }
        return this.handleContentChange(element, this.getRangeInElement(element), newContent);
    }

    @Override
    @NotNull
    public TextRange getRangeInElement(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/AbstractElementManipulator", "getRangeInElement"));
        }
        TextRange textRange = new TextRange(0, element.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/AbstractElementManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

