/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileAttributes;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ArchiveHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;

public class CoreJarHandler
extends ZipHandler {
    private final CoreJarFileSystem myFileSystem;
    private final VirtualFile myRoot;

    public CoreJarHandler(@NotNull CoreJarFileSystem fileSystem, @NotNull String path) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "<init>"));
        }
        super(path);
        this.myFileSystem = fileSystem;
        HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries = new HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile>();
        Map<String, ArchiveHandler.EntryInfo> entriesMap = this.getEntriesMap();
        for (ArchiveHandler.EntryInfo info : entriesMap.values()) {
            this.getOrCreateFile(info, entries);
        }
        ArchiveHandler.EntryInfo rootInfo = this.getEntryInfo("");
        this.myRoot = rootInfo != null ? this.getOrCreateFile(rootInfo, entries) : null;
    }

    @NotNull
    private CoreJarVirtualFile getOrCreateFile(@NotNull ArchiveHandler.EntryInfo info, @NotNull Map<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        CoreJarVirtualFile file = entries.get(info);
        if (file == null) {
            FileAttributes attributes = new FileAttributes(info.isDirectory, false, false, false, info.length, info.timestamp, false);
            ArchiveHandler.EntryInfo parent2 = info.parent;
            file = new CoreJarVirtualFile(this, info.shortName.toString(), attributes, parent2 != null ? this.getOrCreateFile(parent2, entries) : null);
            entries.put(info, file);
        }
        CoreJarVirtualFile coreJarVirtualFile = file;
        if (coreJarVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        return coreJarVirtualFile;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String pathInJar) {
        if (pathInJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInJar", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "findFileByPath"));
        }
        return this.myRoot != null ? this.myRoot.findFileByRelativePath(pathInJar) : null;
    }

    @NotNull
    public CoreJarFileSystem getFileSystem() {
        CoreJarFileSystem coreJarFileSystem = this.myFileSystem;
        if (coreJarFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getFileSystem"));
        }
        return coreJarFileSystem;
    }
}

