/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

public class MethodContext
extends CodegenContext<CallableMemberDescriptor> {
    private Label methodStartLabel;
    private Label methodEndLabel;
    private final FunctionDescriptor functionDescriptor;

    protected MethodContext(@NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind contextKind, @NotNull CodegenContext parentContext, @Nullable MutableClosure closure) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/context/MethodContext", "<init>"));
        }
        if (contextKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextKind", "org/jetbrains/kotlin/codegen/context/MethodContext", "<init>"));
        }
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentContext", "org/jetbrains/kotlin/codegen/context/MethodContext", "<init>"));
        }
        super(JvmCodegenUtil.getDirectMember(functionDescriptor), contextKind, parentContext, closure, parentContext.hasThisDescriptor() ? parentContext.getThisDescriptor() : null, null);
        this.functionDescriptor = functionDescriptor;
    }

    @Override
    @NotNull
    public CodegenContext getParentContext() {
        CodegenContext codegenContext = super.getParentContext();
        if (codegenContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/MethodContext", "getParentContext"));
        }
        return codegenContext;
    }

    public StackValue getReceiverExpression(KotlinTypeMapper typeMapper) {
        assert (this.getCallableDescriptorWithReceiver() != null);
        Type asmType = typeMapper.mapType(this.getCallableDescriptorWithReceiver().getExtensionReceiverParameter().getType());
        return StackValue.local(AsmUtil.getReceiverIndex(this, (CallableMemberDescriptor)this.getContextDescriptor()), asmType);
    }

    @Override
    public StackValue lookupInContext(DeclarationDescriptor d, @Nullable StackValue result2, GenerationState state2, boolean ignoreNoOuter) {
        if (d instanceof SyntheticFieldDescriptor) {
            SyntheticFieldDescriptor fieldDescriptor = (SyntheticFieldDescriptor)d;
            d = fieldDescriptor.getPropertyDescriptor();
        }
        if (this.getContextDescriptor() == d) {
            return result2 != null ? result2 : StackValue.LOCAL_0;
        }
        return this.getParentContext().lookupInContext(d, result2, state2, ignoreNoOuter);
    }

    @Nullable
    public StackValue generateReceiver(@NotNull CallableDescriptor descriptor2, @NotNull GenerationState state2, boolean ignoreNoOuter) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/context/MethodContext", "generateReceiver"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/context/MethodContext", "generateReceiver"));
        }
        if (this.getCallableDescriptorWithReceiver() == descriptor2) {
            return this.getReceiverExpression(state2.getTypeMapper());
        }
        ReceiverParameterDescriptor parameter = descriptor2.getExtensionReceiverParameter();
        return this.lookupInContext(parameter, StackValue.LOCAL_0, state2, ignoreNoOuter);
    }

    @Override
    public StackValue getOuterExpression(StackValue prefix, boolean ignoreNoOuter) {
        return this.getParentContext().getOuterExpression(prefix, false);
    }

    @Nullable
    public Label getMethodStartLabel() {
        return this.methodStartLabel;
    }

    public void setMethodStartLabel(@NotNull Label methodStartLabel) {
        if (methodStartLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodStartLabel", "org/jetbrains/kotlin/codegen/context/MethodContext", "setMethodStartLabel"));
        }
        this.methodStartLabel = methodStartLabel;
    }

    @Nullable
    public Label getMethodEndLabel() {
        return this.methodEndLabel;
    }

    public void setMethodEndLabel(@NotNull Label methodEndLabel) {
        if (methodEndLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodEndLabel", "org/jetbrains/kotlin/codegen/context/MethodContext", "setMethodEndLabel"));
        }
        this.methodEndLabel = methodEndLabel;
    }

    public String toString() {
        return "Method: " + this.getContextDescriptor();
    }

    @Override
    public boolean isInlineMethodContext() {
        return InlineUtil.isInline(this.getContextDescriptor());
    }

    @NotNull
    public FunctionDescriptor getFunctionDescriptor() {
        FunctionDescriptor functionDescriptor = this.functionDescriptor;
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/MethodContext", "getFunctionDescriptor"));
        }
        return functionDescriptor;
    }
}

