/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.modules;

import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.JvmSourceRoot;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jl\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J$\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002J\u0016\u0010\"\u001a\u00020\u001b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/modules/KotlinModuleXmlBuilder;", "", "()V", "done", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "xml", "Ljava/lang/StringBuilder;", "addModule", "moduleName", "", "outputDir", "sourceFiles", "", "Ljava/io/File;", "javaSourceRoots", "Lorg/jetbrains/kotlin/build/JvmSourceRoot;", "classpathRoots", "targetTypeId", "isTests", "directoriesToFilterOut", "", "friendDirs", "asText", "", "closeTag", "", "tag", "getEscapedPath", "sourceFile", "openTag", "processClasspath", "files", "processJavaSourceRoots", "roots", "kotlin-build-common"})
public final class KotlinModuleXmlBuilder {
    private final StringBuilder xml = new StringBuilder();
    private final Printer p = new Printer(this.xml);
    private boolean done;

    @NotNull
    public final KotlinModuleXmlBuilder addModule(@NotNull String moduleName, @NotNull String outputDir2, @NotNull Iterable<? extends File> sourceFiles, @NotNull Iterable<JvmSourceRoot> javaSourceRoots, @NotNull Iterable<? extends File> classpathRoots, @NotNull String targetTypeId, boolean isTests, @NotNull Set<? extends File> directoriesToFilterOut, @NotNull Iterable<? extends File> friendDirs) {
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(outputDir2, "outputDir");
        Intrinsics.checkParameterIsNotNull(sourceFiles, "sourceFiles");
        Intrinsics.checkParameterIsNotNull(javaSourceRoots, "javaSourceRoots");
        Intrinsics.checkParameterIsNotNull(classpathRoots, "classpathRoots");
        Intrinsics.checkParameterIsNotNull(targetTypeId, "targetTypeId");
        Intrinsics.checkParameterIsNotNull(directoriesToFilterOut, "directoriesToFilterOut");
        Intrinsics.checkParameterIsNotNull(friendDirs, "friendDirs");
        boolean bl = !this.done;
        if (_Assertions.ENABLED && !bl) {
            String string = "Already done";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.p.println("<!-- Module script for " + (isTests ? "tests" : "production") + " -->");
        this.p.println("<", "module", " ", "name", "=\"", StringUtil.escapeXml(moduleName), "\" ", "type", "=\"", StringUtil.escapeXml(targetTypeId), "\" ", "outputDir", "=\"", this.getEscapedPath(new File(outputDir2)), "\">");
        this.p.pushIndent();
        for (File file : friendDirs) {
            this.p.println("<", "friendDir", " ", "path", "=\"", this.getEscapedPath(file), "\"/>");
        }
        for (File file : sourceFiles) {
            this.p.println("<", "sources", " ", "path", "=\"", this.getEscapedPath(file), "\"/>");
        }
        this.processJavaSourceRoots(javaSourceRoots);
        this.processClasspath(classpathRoots, directoriesToFilterOut);
        this.closeTag(this.p, "module");
        return this;
    }

    private final void processClasspath(Iterable<? extends File> files, Set<? extends File> directoriesToFilterOut) {
        this.p.println("<!-- Classpath -->");
        for (File file : files) {
            boolean isOutput;
            boolean bl = isOutput = directoriesToFilterOut.contains(file) && !IncrementalCompilation.isEnabled();
            if (isOutput) {
                this.p.println("<!-- Output directory, commented out -->");
                this.p.println("<!-- ");
                this.p.pushIndent();
            }
            this.p.println("<", "classpath", " ", "path", "=\"", this.getEscapedPath(file), "\"/>");
            if (!isOutput) continue;
            this.p.popIndent();
            this.p.println("-->");
        }
    }

    private final void processJavaSourceRoots(Iterable<JvmSourceRoot> roots2) {
        this.p.println("<!-- Java source roots -->");
        for (JvmSourceRoot root : roots2) {
            this.p.print("<");
            this.p.printWithNoIndent("javaSourceRoots", " ", "path", "=\"", this.getEscapedPath(root.getFile()), "\"");
            if (root.getPackagePrefix() != null) {
                this.p.printWithNoIndent(" ", "packagePrefix", "=\"", root.getPackagePrefix(), "\"");
            }
            this.p.printWithNoIndent("/>");
            this.p.println(new Object[0]);
        }
    }

    @NotNull
    public final CharSequence asText() {
        if (!this.done) {
            this.closeTag(this.p, "modules");
            this.done = true;
        }
        return this.xml;
    }

    private final void openTag(Printer p, String tag) {
        p.println("<" + tag + ">");
        p.pushIndent();
    }

    private final void closeTag(Printer p, String tag) {
        p.popIndent();
        p.println("</" + tag + ">");
    }

    private final String getEscapedPath(File sourceFile) {
        String string = StringUtil.escapeXml(FileUtil.toSystemIndependentName(sourceFile.getPath()));
        Intrinsics.checkExpressionValueIsNotNull(string, "escapeXml(toSystemIndepe\u2026entName(sourceFile.path))");
        return string;
    }

    public KotlinModuleXmlBuilder() {
        this.openTag(this.p, "modules");
    }
}

