/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LogUtil;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.ImmutableCharSequence;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.LazyParseableElement");
    private final ChameleonLock lock;
    private CharSequence myText;
    private static final ThreadLocal<Boolean> ourSuppressEagerPsiCreation = new ThreadLocal();
    private static boolean ourParsingAllowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyParseableElement(@NotNull IElementType type2, @Nullable CharSequence text) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "<init>"));
        }
        super(type2);
        this.lock = new ChameleonLock();
        if (text != null) {
            ChameleonLock chameleonLock = this.lock;
            synchronized (chameleonLock) {
                this.myText = ImmutableCharSequence.asImmutable(text);
            }
            this.setCachedLength(text.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myText != null) {
                this.setCachedLength(this.myText.length());
            }
        }
    }

    @Override
    @NotNull
    public String getText() {
        CharSequence text = this.myText();
        if (text != null) {
            String string = text.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "getText"));
            }
            return string;
        }
        String string = super.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence text = this.myText();
        if (text != null) {
            CharSequence charSequence = text;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "getChars"));
            }
            return charSequence;
        }
        String string = super.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "getChars"));
        }
        return string;
    }

    @Override
    public int getTextLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getTextLength();
    }

    @Override
    public int getNotCachedLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getNotCachedLength();
    }

    @Override
    public int hc() {
        CharSequence text = this.myText();
        return text == null ? super.hc() : LeafElement.leafHC(text);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "textMatches"));
        }
        CharSequence text = this.myText();
        if (text != null) {
            return LeafElement.leafTextMatches(text, buffer, start);
        }
        return super.textMatches(buffer, start);
    }

    public boolean isParsed() {
        return this.myText() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence myText() {
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            return this.myText;
        }
    }

    @Override
    final void setFirstChildNode(TreeElement child) {
        if (this.myText() != null) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child);
    }

    @Override
    final void setLastChildNode(TreeElement child) {
        if (this.myText() != null) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void ensureParsed() {
        ASTNode parsedNode;
        block14: {
            CharSequence text;
            if (!ourParsingAllowed) {
                LOG.error("Parsing not allowed!!!");
            }
            if ((text = this.myText()) == null) {
                return;
            }
            if (TreeUtil.getFileElement(this) == null) {
                LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            DebugUtil.startPsiModification("lazy-parsing");
            ILazyParseableElementType type2 = (ILazyParseableElementType)this.getElementType();
            parsedNode = type2.parseContents(this);
            if (parsedNode == null && text.length() > 0) {
                CharSequence diagText = ApplicationManager.getApplication().isInternal() ? text : "";
                LOG.error("No parse for a non-empty string: " + diagText + "; type=" + LogUtil.objectAndClass(type2));
            }
            ChameleonLock chameleonLock = this.lock;
            // MONITORENTER : chameleonLock
            if (this.myText != null) break block14;
            // MONITOREXIT : chameleonLock
            DebugUtil.finishPsiModification();
            return;
        }
        if (this.rawFirstChild() != null) {
            LOG.error("Reentrant parsing?");
        }
        this.myText = null;
        if (parsedNode == null) {
            // MONITOREXIT : chameleonLock
            DebugUtil.finishPsiModification();
            return;
        }
        try {
            super.rawAddChildrenWithoutNotifications((TreeElement)parsedNode);
            // MONITOREXIT : chameleonLock
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        if (Boolean.TRUE.equals(ourSuppressEagerPsiCreation.get())) return;
        this.createAllChildrenPsiIfNecessary();
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseableElement", "rawAddChildrenWithoutNotifications"));
        }
        if (this.myText() != null) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(@Nullable char[] buffer, int start) {
        CharSequence text = this.myText();
        if (text == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars(text, buffer, start);
        }
        return start + text.length();
    }

    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    public static void setSuppressEagerPsiCreation(boolean suppress) {
        ourSuppressEagerPsiCreation.set(suppress);
    }

    private static class ChameleonLock {
        private ChameleonLock() {
        }

        @NonNls
        public String toString() {
            return "chameleon parsing lock";
        }
    }
}

