/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.impl.providers;

import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.text.StringFactory;

public class PsiFileSystemItemUtil {
    @Nullable
    static PsiFileSystemItem getCommonAncestor(PsiFileSystemItem file1, PsiFileSystemItem file2) {
        PsiFileSystemItem[] maxLengthPath;
        PsiFileSystemItem[] minLengthPath;
        PsiFileSystemItem[] path2;
        PsiFileSystemItem[] path1 = PsiFileSystemItemUtil.getPathComponents(file1);
        if (path1.length < (path2 = PsiFileSystemItemUtil.getPathComponents(file2)).length) {
            minLengthPath = path1;
            maxLengthPath = path2;
        } else {
            minLengthPath = path2;
            maxLengthPath = path1;
        }
        int lastEqualIdx = -1;
        int i = 0;
        while (i < minLengthPath.length && minLengthPath[i].equals(maxLengthPath[i])) {
            lastEqualIdx = i++;
        }
        return lastEqualIdx != -1 ? minLengthPath[lastEqualIdx] : null;
    }

    static PsiFileSystemItem[] getPathComponents(PsiFileSystemItem file) {
        LinkedList<PsiFileSystemItem> componentsList = new LinkedList<PsiFileSystemItem>();
        while (file != null) {
            componentsList.addFirst(file);
            file = file.getParent();
        }
        return componentsList.toArray(new PsiFileSystemItem[componentsList.size()]);
    }

    @NotNull
    public static String getNotNullRelativePath(PsiFileSystemItem src, PsiFileSystemItem dst) throws IncorrectOperationException {
        String s = PsiFileSystemItemUtil.getRelativePath(src, dst);
        if (s == null) {
            throw new IncorrectOperationException("Cannot find path between files; src = " + src.getVirtualFile().getPresentableUrl() + "; dst = " + dst.getVirtualFile().getPresentableUrl());
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileSystemItemUtil", "getNotNullRelativePath"));
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(PsiFileSystemItem src, PsiFileSystemItem dst) {
        PsiFileSystemItem commonAncestor = PsiFileSystemItemUtil.getCommonAncestor(src, dst);
        if (commonAncestor != null) {
            StringBuilder buffer = new StringBuilder();
            if (!src.equals(commonAncestor)) {
                while (!commonAncestor.equals(src.getParent())) {
                    buffer.append("..").append('/');
                    src = src.getParent();
                    assert (src != null);
                }
            }
            buffer.append(PsiFileSystemItemUtil.getRelativePathFromAncestor(dst, commonAncestor));
            return buffer.toString();
        }
        return null;
    }

    @Nullable
    public static String getRelativePathFromAncestor(PsiFileSystemItem file, PsiFileSystemItem ancestor) {
        int length = 0;
        PsiFileSystemItem parent2 = file;
        while (true) {
            if (parent2 == null) {
                return null;
            }
            if (parent2.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent2.getName().length();
            parent2 = parent2.getParent();
        }
        char[] chars = new char[length];
        int index2 = chars.length;
        parent2 = file;
        while (!parent2.equals(ancestor)) {
            if (index2 < length) {
                chars[--index2] = 47;
            }
            String name = parent2.getName();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index2] = name.charAt(i);
            }
            parent2 = parent2.getParent();
        }
        return StringFactory.createShared(chars);
    }
}

