/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTag;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTagValue;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

class ClsDocTagImpl
extends ClsElementImpl
implements PsiDocTag {
    private final ClsDocCommentImpl myDocComment;
    private final PsiElement myNameElement;

    ClsDocTagImpl(ClsDocCommentImpl docComment, @NonNls String name) {
        this.myDocComment = docComment;
        this.myNameElement = new NameElement(this, name);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl", "appendMirrorText"));
        }
        buffer.append(this.myNameElement.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaDocElementType.DOC_TAG);
    }

    @Override
    public String getText() {
        return this.myNameElement.getText();
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.myNameElement.textToCharArray();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl", "textToCharArray"));
        }
        return cArray;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getNameElement().getText().substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl", "getName"));
        }
        return string;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl", "textMatches"));
        }
        return this.myNameElement.textMatches(text);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl", "textMatches"));
        }
        return this.myNameElement.textMatches(element);
    }

    @Override
    public int getTextLength() {
        return this.myNameElement.getTextLength();
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myNameElement};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getParent() {
        return this.getContainingComment();
    }

    @Override
    public PsiDocComment getContainingComment() {
        return this.myDocComment;
    }

    @Override
    public PsiElement getNameElement() {
        return this.myNameElement;
    }

    @Override
    public PsiElement[] getDataElements() {
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiDocTagValue getValueElement() {
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitDocTag(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl", "setName"));
        }
        PsiImplUtil.setName(this.getNameElement(), name);
        return this;
    }

    private static class NameElement
    extends ClsElementImpl {
        private final ClsDocTagImpl myParent;
        private final String myText;

        public NameElement(ClsDocTagImpl parent2, String text) {
            this.myParent = parent2;
            this.myText = text;
        }

        @Override
        public String getText() {
            return this.myText;
        }

        @Override
        @NotNull
        public char[] textToCharArray() {
            char[] cArray = this.myText.toCharArray();
            if (cArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement", "textToCharArray"));
            }
            return cArray;
        }

        @Override
        @NotNull
        public PsiElement[] getChildren() {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement", "getChildren"));
            }
            return PsiElement.EMPTY_ARRAY;
        }

        @Override
        public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
            if (buffer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement", "appendMirrorText"));
            }
        }

        @Override
        public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement", "setMirror"));
            }
            this.setMirrorCheckingType(element, null);
        }

        @Override
        public PsiElement getParent() {
            return this.myParent;
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsDocTagImpl$NameElement", "accept"));
            }
            visitor2.visitElement(this);
        }
    }
}

