/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;

public class PsiArrayType
extends PsiType.Stub {
    private final PsiType myComponentType;

    public PsiArrayType(@NotNull PsiType componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "<init>"));
        }
        this(componentType, PsiAnnotation.EMPTY_ARRAY);
    }

    public PsiArrayType(@NotNull PsiType componentType, @NotNull PsiAnnotation[] annotations2) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "<init>"));
        }
        super(annotations2);
        this.myComponentType = componentType;
    }

    public PsiArrayType(@NotNull PsiType componentType, @NotNull TypeAnnotationProvider annotations2) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "<init>"));
        }
        super(annotations2);
        this.myComponentType = componentType;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = this.getText(this.myComponentType.getPresentableText(), "[]", false, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(this.myComponentType.getCanonicalText(annotated), "[]", true, annotated);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getText(this.myComponentType.getInternalCanonicalText(), "[]", true, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "getInternalCanonicalText"));
        }
        return string;
    }

    protected String getText(@NotNull String prefix, @NotNull String suffix, boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations2;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "getText"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "getText"));
        }
        StringBuilder sb = new StringBuilder(prefix.length() + suffix.length());
        sb.append(prefix);
        if (annotated && (annotations2 = this.getAnnotations()).length != 0) {
            sb.append(' ');
            PsiNameHelper.appendAnnotations(sb, annotations2, qualified);
        }
        sb.append(suffix);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return this.myComponentType.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "equalsToText"));
        }
        return text.endsWith("[]") && this.myComponentType.equalsToText(text.substring(0, text.length() - 2));
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "accept"));
        }
        return visitor2.visitArrayType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myComponentType.getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] superTypes2 = this.myComponentType.getSuperTypes();
        PsiType[] result2 = PsiArrayType.createArray(superTypes2.length);
        for (int i = 0; i < superTypes2.length; ++i) {
            result2[i] = superTypes2[i].createArrayType();
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "getSuperTypes"));
        }
        return result2;
    }

    @NotNull
    public PsiType getComponentType() {
        PsiType psiType = this.myComponentType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType", "getComponentType"));
        }
        return psiType;
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiArrayType && this instanceof PsiEllipsisType == obj instanceof PsiEllipsisType && this.myComponentType.equals(((PsiArrayType)obj).getComponentType());
    }

    public int hashCode() {
        return this.myComponentType.hashCode() * 3;
    }
}

