/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.CodegenUtil$getDelegates$;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J;\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u001b\"\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010\u001cJ\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0007J0\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020%0\u00042\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00152\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0007J\u001f\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010/J\u001c\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010&\u001a\u00020\u0015H\u0007J\u0018\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u0002032\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u0005H\u0007J\u001a\u00106\u001a\u00020\u00122\b\u00107\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020)2\u0006\u0010:\u001a\u00020\u0019H\u0002J$\u0010;\u001a\u00020\u00122\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00190=H\u0002\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/backend/common/CodegenUtil;", "", "()V", "copyFunctions", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "inheritedMember", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "traitMember", "newOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "modality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "kind", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "copyOverrides", "", "getDeclaredFunctionByRawSignature", "owner", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "returnedClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "valueParameterClassifiers", "", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;[Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getDelegatePropertyIfAny", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "classDescriptor", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDelegates", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "descriptor", "toInterface", "delegateExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getLineNumberForElement", "", "statement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "markEndOffset", "(Lcom/intellij/psi/PsiElement;Z)Ljava/lang/Integer;", "getNonPrivateTraitMethods", "getSuperClassBySuperTypeListEntry", "specifier", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "isEnumValueOfMethod", "functionDescriptor", "isFinalPropertyWithBackingField", "propertyDescriptor", "rawTypeMatches", "type", "classifier", "valueParameterClassesMatch", "parameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "classifiers", "kotlin-compiler"})
public final class CodegenUtil {
    public static final CodegenUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final Map<CallableMemberDescriptor, CallableDescriptor> getDelegates(@NotNull ClassDescriptor descriptor2, @NotNull ClassDescriptor toInterface, @Nullable KotlinType delegateExpressionType) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(toInterface, "toInterface");
        KotlinType kotlinType = delegateExpressionType;
        if (kotlinType != null ? DynamicTypesKt.isDynamic(kotlinType) : false) {
            return MapsKt.emptyMap();
        }
        Sequence $receiver$iv = kotlin.collections.CollectionsKt.asSequence(ResolutionScope.DefaultImpls.getContributedDescriptors$default(descriptor2.getDefaultType().getMemberScope(), null, null, 3, null));
        Sequence sequence2 = SequencesKt.filter($receiver$iv, getDelegates$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Iterable iterable = SequencesKt.asIterable(SequencesKt.filter(sequence2, getDelegates.1.INSTANCE));
        Comparator comparator = MemberComparator.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull(comparator, "MemberComparator.INSTANCE");
        return CollectionsKt.keysToMapExceptNulls(kotlin.collections.CollectionsKt.sortedWith(iterable, comparator), (Function1)new Function1<CallableMemberDescriptor, CallableMemberDescriptor>(toInterface, delegateExpressionType){
            final /* synthetic */ ClassDescriptor $toInterface;
            final /* synthetic */ KotlinType $delegateExpressionType;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CallableMemberDescriptor invoke(@NotNull CallableMemberDescriptor delegatingMember) {
                void destination$iv$iv;
                void $receiver$iv$iv$iv;
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull(delegatingMember, "delegatingMember");
                Iterable $receiver$iv = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)delegatingMember);
                Iterable iterable = $receiver$iv;
                Object object = new ArrayList<E>();
                void var5_6 = $receiver$iv$iv;
                for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                    CallableMemberDescriptor callableMemberDescriptor;
                    T element$iv$iv = element$iv$iv$iv;
                    CallableMemberDescriptor overriddenDescriptor = (CallableMemberDescriptor)element$iv$iv;
                    if (Intrinsics.areEqual(overriddenDescriptor.getContainingDeclaration(), this.$toInterface)) {
                        Object v7;
                        block7: {
                            void $receiver$iv2;
                            Name name;
                            KotlinType kotlinType = this.$delegateExpressionType;
                            if (kotlinType == null) {
                                KotlinType kotlinType2 = this.$toInterface.getDefaultType();
                                kotlinType = kotlinType2;
                                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "toInterface.defaultType");
                            }
                            MemberScope scope = kotlinType.getMemberScope();
                            Name name2 = name = overriddenDescriptor.getName();
                            Intrinsics.checkExpressionValueIsNotNull(name2, "name");
                            Collection<SimpleFunctionDescriptor> collection = scope.getContributedFunctions(name2, NoLookupLocation.FROM_BACKEND);
                            Name name3 = name;
                            Intrinsics.checkExpressionValueIsNotNull(name3, "name");
                            Iterable iterable2 = kotlin.collections.CollectionsKt.plus(collection, (Iterable)scope.getContributedVariables(name3, NoLookupLocation.FROM_BACKEND));
                            for (T element$iv : $receiver$iv2) {
                                void destination$iv$iv2;
                                void $receiver$iv$iv2;
                                void $receiver$iv3;
                                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                                Collection collection2 = kotlin.collections.CollectionsKt.listOf(it);
                                Iterable iterable3 = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)it);
                                Intrinsics.checkExpressionValueIsNotNull(iterable3, "DescriptorUtils.getAllOverriddenDescriptors(it)");
                                Iterable iterable4 = kotlin.collections.CollectionsKt.plus(collection2, iterable3);
                                void var17_18 = $receiver$iv3;
                                Collection collection3 = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv3, 10));
                                for (T item$iv$iv : $receiver$iv$iv2) {
                                    void p1;
                                    CallableMemberDescriptor callableMemberDescriptor2 = (CallableMemberDescriptor)item$iv$iv;
                                    void var22_23 = destination$iv$iv2;
                                    CallableMemberDescriptor callableMemberDescriptor3 = p1.getOriginal();
                                    var22_23.add(callableMemberDescriptor3);
                                }
                                if (!((List)destination$iv$iv2).contains(overriddenDescriptor.getOriginal())) continue;
                                v7 = element$iv;
                                break block7;
                            }
                            v7 = null;
                        }
                        callableMemberDescriptor = v7;
                    } else {
                        callableMemberDescriptor = null;
                    }
                    if (callableMemberDescriptor == null) continue;
                    CallableMemberDescriptor callableMemberDescriptor4 = callableMemberDescriptor;
                    CallableMemberDescriptor it$iv$iv = callableMemberDescriptor4;
                    destination$iv$iv.add(it$iv$iv);
                }
                List actualDelegates = (List)destination$iv$iv;
                boolean bl = actualDelegates.size() <= 1;
                if (_Assertions.ENABLED && !bl) {
                    object = "Many delegates found for " + delegatingMember + ": " + actualDelegates;
                    throw (Throwable)((Object)new AssertionError(object));
                }
                return (CallableMemberDescriptor)kotlin.collections.CollectionsKt.firstOrNull(actualDelegates);
            }
            {
                this.$toInterface = classDescriptor;
                this.$delegateExpressionType = kotlinType;
                super(1);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static /* bridge */ /* synthetic */ Map getDelegates$default(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2, KotlinType kotlinType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDelegates");
        }
        if ((n & 4) != 0) {
            kotlinType = null;
        }
        return CodegenUtil.getDelegates(classDescriptor, classDescriptor2, kotlinType);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @Nullable
    public static final FunctionDescriptor getDeclaredFunctionByRawSignature(@NotNull ClassDescriptor owner, @NotNull Name name, @NotNull ClassifierDescriptor returnedClassifier, ClassifierDescriptor ... valueParameterClassifiers) {
        Object element$iv;
        Object v0;
        boolean bl;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(returnedClassifier, "returnedClassifier");
        Intrinsics.checkParameterIsNotNull(valueParameterClassifiers, "valueParameterClassifiers");
        Iterable iterable = owner.getDefaultType().getMemberScope().getContributedFunctions(name, NoLookupLocation.FROM_BACKEND);
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator2.next();
            SimpleFunctionDescriptor function = (SimpleFunctionDescriptor)element$iv;
            if (!CallResolverUtilKt.isOrOverridesSynthesized(function) && function.getTypeParameters().isEmpty()) {
                List<ValueParameterDescriptor> list2 = function.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, "function.valueParameters");
                if (INSTANCE.valueParameterClassesMatch(list2, ArraysKt.toList((Object[])valueParameterClassifiers))) {
                    KotlinType kotlinType = function.getReturnType();
                    if (kotlinType == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "function.returnType!!");
                    if (INSTANCE.rawTypeMatches(kotlinType, returnedClassifier)) {
                        bl = true;
                        continue;
                    }
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    @JvmStatic
    @Nullable
    public static final PropertyDescriptor getDelegatePropertyIfAny(@NotNull KtExpression expression, @NotNull ClassDescriptor classDescriptor, @NotNull BindingContext bindingContext) {
        Object object;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        KtExpression ktExpression = expression;
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        if ((object = (KtSimpleNameExpression)ktExpression) == null || (object = CallUtilKt.getResolvedCall((KtElement)object, bindingContext)) == null) {
            return null;
        }
        Object call = object;
        Object d = call.getResultingDescriptor();
        if (!(d instanceof ValueParameterDescriptor)) {
            d = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)d;
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor callResultingDescriptor = valueParameterDescriptor;
        if (callResultingDescriptor.getContainingDeclaration() instanceof ConstructorDescriptor && callResultingDescriptor.getContainingDeclaration().getContainingDeclaration() == classDescriptor) {
            return (PropertyDescriptor)bindingContext.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, callResultingDescriptor);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isFinalPropertyWithBackingField(@Nullable PropertyDescriptor propertyDescriptor, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        if (propertyDescriptor == null) return false;
        if (propertyDescriptor.isVar()) return false;
        Boolean bl = (Boolean)bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        if (bl == null) return false;
        boolean bl2 = bl;
        if (!bl2) return false;
        return true;
    }

    @JvmStatic
    @NotNull
    public static final Map<FunctionDescriptor, FunctionDescriptor> getNonPrivateTraitMethods(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        LinkedHashMap<FunctionDescriptor, FunctionDescriptor> result2 = MapsKt.linkedMapOf(new Pair[0]);
        for (DeclarationDescriptor declaration : DescriptorUtils.getAllDescriptors(descriptor2.getDefaultType().getMemberScope())) {
            CallableMemberDescriptor traitMember;
            if (!(declaration instanceof CallableMemberDescriptor) || (traitMember = ImplKt.findTraitImplementation((CallableMemberDescriptor)declaration)) == null || Visibilities.isPrivate(traitMember.getVisibility())) continue;
            boolean bl = traitMember.getModality() != Modality.ABSTRACT;
            if (_Assertions.ENABLED && !bl) {
                String string = "Cannot delegate to abstract trait method: " + declaration;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declaration;
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)declaration).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "declaration.containingDeclaration");
            Modality modality = traitMember.getModality();
            Intrinsics.checkExpressionValueIsNotNull((Object)modality, "traitMember.modality");
            Visibility visibility = Visibilities.PUBLIC;
            Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.PUBLIC");
            result2.putAll(INSTANCE.copyFunctions(callableMemberDescriptor, traitMember, declarationDescriptor, modality, visibility, CallableMemberDescriptor.Kind.DECLARATION, true));
        }
        return result2;
    }

    @NotNull
    public final Map<FunctionDescriptor, FunctionDescriptor> copyFunctions(@NotNull CallableMemberDescriptor inheritedMember, @NotNull CallableMemberDescriptor traitMember, @NotNull DeclarationDescriptor newOwner, @NotNull Modality modality, @NotNull Visibility visibility, @NotNull CallableMemberDescriptor.Kind kind, boolean copyOverrides) {
        Intrinsics.checkParameterIsNotNull(inheritedMember, "inheritedMember");
        Intrinsics.checkParameterIsNotNull(traitMember, "traitMember");
        Intrinsics.checkParameterIsNotNull(newOwner, "newOwner");
        Intrinsics.checkParameterIsNotNull((Object)modality, "modality");
        Intrinsics.checkParameterIsNotNull(visibility, "visibility");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        CallableMemberDescriptor copy = inheritedMember.copy(newOwner, modality, visibility, kind, copyOverrides);
        LinkedHashMap<PropertyAccessorDescriptor, PropertyAccessorDescriptor> result2 = MapsKt.linkedMapOf(new Pair[0]);
        if (traitMember instanceof SimpleFunctionDescriptor) {
            Map map2 = result2;
            CallableMemberDescriptor callableMemberDescriptor = copy;
            if (callableMemberDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableMemberDescriptor;
            map2.put(traitMember, functionDescriptor);
        } else if (traitMember instanceof PropertyDescriptor) {
            for (PropertyAccessorDescriptor traitAccessor : ((PropertyDescriptor)traitMember).getAccessors()) {
                CallableMemberDescriptor callableMemberDescriptor = copy;
                if (callableMemberDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                }
                for (PropertyAccessorDescriptor inheritedAccessor : ((PropertyDescriptor)callableMemberDescriptor).getAccessors()) {
                    if (!Intrinsics.areEqual(inheritedAccessor.getClass(), traitAccessor.getClass())) continue;
                    result2.put(traitAccessor, inheritedAccessor);
                }
            }
        }
        return result2;
    }

    @JvmStatic
    @NotNull
    public static final ClassDescriptor getSuperClassBySuperTypeListEntry(@NotNull KtSuperTypeListEntry specifier, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(specifier, "specifier");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        ReadOnlySlice readOnlySlice = BindingContext.TYPE;
        KtTypeReference ktTypeReference = specifier.getTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KotlinType kotlinType = (KotlinType)bindingContext.get(readOnlySlice, ktTypeReference);
        if (kotlinType == null) {
            String string = "superType should not be null: " + specifier.getText();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KotlinType superType = kotlinType;
        ClassifierDescriptor classifierDescriptor = superType.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            String string = "ClassDescriptor of superType should not be null: " + specifier.getText();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return classDescriptor;
    }

    private final boolean valueParameterClassesMatch(List<? extends ValueParameterDescriptor> parameters2, List<? extends ClassifierDescriptor> classifiers) {
        if (parameters2.size() != classifiers.size()) {
            return false;
        }
        for (Pair pair : kotlin.collections.CollectionsKt.zip((Iterable)parameters2, (Iterable)classifiers)) {
            ValueParameterDescriptor parameterDescriptor = (ValueParameterDescriptor)pair.component1();
            ClassifierDescriptor classDescriptor = (ClassifierDescriptor)pair.component2();
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameterDescriptor.type");
            if (this.rawTypeMatches(kotlinType, classDescriptor)) continue;
            return false;
        }
        return true;
    }

    private final boolean rawTypeMatches(KotlinType type2, ClassifierDescriptor classifier2) {
        return Intrinsics.areEqual(type2.getConstructor(), classifier2.getTypeConstructor());
    }

    @JvmStatic
    public static final boolean isEnumValueOfMethod(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        List<ValueParameterDescriptor> methodTypeParameters = functionDescriptor.getValueParameters();
        KotlinType nullableString = TypeUtils.makeNullable(DescriptorUtilsKt.getBuiltIns(functionDescriptor).getStringType());
        return Intrinsics.areEqual(DescriptorUtils.ENUM_VALUE_OF, functionDescriptor.getName()) && methodTypeParameters.size() == 1 && KotlinTypeChecker.DEFAULT.isSubtypeOf(methodTypeParameters.get(0).getType(), nullableString);
    }

    @JvmStatic
    @Nullable
    public static final Integer getLineNumberForElement(@NotNull PsiElement statement, boolean markEndOffset) {
        Document document;
        Intrinsics.checkParameterIsNotNull(statement, "statement");
        PsiFile file = statement.getContainingFile();
        if (file instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file) != null) {
            return null;
        }
        if (statement instanceof KtConstructorDelegationReferenceExpression && ((KtConstructorDelegationReferenceExpression)statement).getTextLength() == 0) {
            return null;
        }
        Document document2 = document = file.getViewProvider().getDocument();
        return document2 != null ? Integer.valueOf(document2.getLineNumber(markEndOffset ? statement.getTextRange().getEndOffset() : statement.getTextOffset()) + 1) : null;
    }

    private CodegenUtil() {
        INSTANCE = this;
    }

    static {
        new CodegenUtil();
    }
}

