/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.KtLightFieldImpl;
import org.jetbrains.kotlin.asJava.KtLightMethodImpl;
import org.jetbrains.kotlin.asJava.LightMemberOriginForDeclaration;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.AbstractLightClass;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.ClassInnerStuffCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiExtensibleClass;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

public abstract class KtWrappingLightClass
extends AbstractLightClass
implements PsiExtensibleClass,
KtLightClass {
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);

    protected KtWrappingLightClass(PsiManager manager) {
        super(manager, KotlinLanguage.INSTANCE);
    }

    @Override
    @NotNull
    public PsiClass getDelegate() {
        PsiClass psiClass = (PsiClass)this.getClsDelegate();
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getDelegate"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getFields"));
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getConstructors"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getInnerClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getAllFields"));
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiField findFieldByName(String name, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name, checkBases);
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @Override
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name, checkBases);
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiField> list2 = ContainerUtil.map(this.getDelegate().getFields(), new Function<PsiField, PsiField>(){

            @Override
            public PsiField fun(PsiField field) {
                LightMemberOriginForDeclaration origin = ClsWrapperStubPsiFactory.getMemberOrigin(field);
                return KtLightFieldImpl.Factory.create(origin, field, KtWrappingLightClass.this);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getOwnFields"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiMethod> list2 = ArraysKt.map(this.getDelegate().getMethods(), new Function1<PsiMethod, PsiMethod>(){

            @Override
            public PsiMethod invoke(PsiMethod method) {
                KtDeclaration originalElement;
                LightMemberOriginForDeclaration origin = ClsWrapperStubPsiFactory.getMemberOrigin(method);
                KtDeclaration ktDeclaration = originalElement = origin != null ? origin.getOriginalElement() : null;
                if (originalElement instanceof KtPropertyAccessor) {
                    origin = origin.copy(PsiTreeUtil.getParentOfType((PsiElement)originalElement, KtProperty.class), origin.getOriginKind());
                }
                return KtLightMethodImpl.Factory.create(method, origin, KtWrappingLightClass.this);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getOwnMethods"));
        }
        return list2;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "processDeclarations"));
        }
        if (this.isEnum() && !PsiClassImplUtil.processDeclarationsInEnum(processor, state2, this.myInnersCache)) {
            return false;
        }
        return super.processDeclarations(processor, state2, lastParent, place);
    }

    @Override
    public String getText() {
        KtClassOrObject origin = (KtClassOrObject)this.getKotlinOrigin();
        return origin == null ? "" : origin.getText();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        if (kotlinLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getLanguage"));
        }
        return kotlinLanguage;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public PsiElement getContext() {
        return this.getParent();
    }
}

