/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.clean.TemporaryAssignmentElimination;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBreak;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContinue;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0006J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination;", "", "root", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBlock;", "(Lcom/google/dart/compiler/backend/js/ast/JsBlock;)V", "hasChanges", "", "mappedUsages", "", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "namesToProcess", "", "statementsToRemove", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "syntheticNames", "usageCount", "", "usages", "analyze", "", "apply", "calculateDeclarations", "generateDeclarations", "getUsage", "name", "process", "tryRecord", "expr", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "usage", "use", "Usage", "kotlin-compiler"})
public final class TemporaryAssignmentElimination {
    private final Map<JsName, Integer> usageCount;
    private final Map<JsName, Usage> usages;
    private final Set<JsStatement> statementsToRemove;
    private final Map<JsName, Usage> mappedUsages;
    private final Set<JsName> syntheticNames;
    private boolean hasChanges;
    private final Set<JsName> namesToProcess;
    private final JsBlock root;

    public final boolean apply() {
        this.analyze();
        this.calculateDeclarations();
        this.process();
        this.generateDeclarations();
        return this.hasChanges;
    }

    private final void analyze() {
        this.namesToProcess.addAll((Collection<JsName>)CollectUtilsKt.collectDefinedNames(this.root));
        new RecursiveJsVisitor(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression returnExpr = x.getExpression();
                if (returnExpr != null) {
                    TemporaryAssignmentElimination.access$tryRecord(this.this$0, returnExpr, new Usage.Return(x));
                }
                super.visitReturn(x);
            }

            /*
             * WARNING - void declaration
             */
            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Pair<JsName, JsExpression> variableAssignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (variableAssignment != null) {
                    void value;
                    void name;
                    Pair<JsName, JsExpression> pair = variableAssignment;
                    JsName jsName = pair.component1();
                    JsExpression jsExpression = pair.component2();
                    pair = null;
                    JsStatement jsStatement = x;
                    void v1 = name;
                    Intrinsics.checkExpressionValueIsNotNull(v1, "name");
                    Usage.VariableAssignment usage = new Usage.VariableAssignment(jsStatement, (JsName)v1);
                    if (MetadataProperties.getSynthetic(x)) {
                        Collection collection = TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0);
                        collection.add(name);
                    }
                    void v2 = value;
                    Intrinsics.checkExpressionValueIsNotNull(v2, "value");
                    TemporaryAssignmentElimination.access$tryRecord(this.this$0, (JsExpression)v2, usage);
                    this.accept((JsNode)value);
                    return;
                }
                Pair<JsExpression, JsExpression> propertyMutation = JsAstUtils.decomposeAssignment(x.getExpression());
                if (propertyMutation != null) {
                    void target;
                    Pair<JsExpression, JsExpression> pair = propertyMutation;
                    JsExpression value = pair.component1();
                    JsExpression usage = pair.component2();
                    pair = null;
                    if (!SideEffectUtilsKt.canHaveSideEffect((JsExpression)target)) {
                        void value2;
                        JsStatement jsStatement = x;
                        void v4 = target;
                        Intrinsics.checkExpressionValueIsNotNull(v4, "target");
                        Usage.PropertyMutation usage2 = new Usage.PropertyMutation(jsStatement, (JsExpression)v4);
                        void v5 = value2;
                        Intrinsics.checkExpressionValueIsNotNull(v5, "value");
                        TemporaryAssignmentElimination.access$tryRecord(this.this$0, (JsExpression)v5, usage2);
                        this.accept((JsNode)value2);
                        return;
                    }
                }
                super.visitExpressionStatement(x);
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                if (x.getVars().size() == 1) {
                    JsVars.JsVar declaration = x.getVars().get(0);
                    JsExpression initExpression = declaration.getInitExpression();
                    if (initExpression != null) {
                        JsStatement jsStatement = x;
                        JsName jsName = declaration.getName();
                        Intrinsics.checkExpressionValueIsNotNull(jsName, "declaration.name");
                        TemporaryAssignmentElimination.access$tryRecord(this.this$0, initExpression, new Usage.VariableDeclaration(jsStatement, jsName));
                    }
                    if (MetadataProperties.getSynthetic(x)) {
                        Collection collection = TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0);
                        JsName jsName = declaration.getName();
                        collection.add(jsName);
                    }
                }
                Iterable $receiver$iv = x.getVars();
                for (T element$iv : $receiver$iv) {
                    Unit unit;
                    JsVars.JsVar v = (JsVars.JsVar)element$iv;
                    JsNode jsNode = v;
                    if (jsNode != null && (jsNode = jsNode.getInitExpression()) != null) {
                        JsNode jsNode2 = jsNode;
                        JsExpression it = (JsExpression)jsNode2;
                        this.accept((JsNode)it);
                        unit = Unit.INSTANCE;
                        continue;
                    }
                    unit = null;
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
                JsName name = nameRef.getName();
                if (name != null && nameRef.getQualifier() == null) {
                    TemporaryAssignmentElimination.access$use(this.this$0, name);
                    return;
                }
                super.visitNameRef(nameRef);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Iterable $receiver$iv = CollectUtilsKt.collectFreeVariables(x);
                for (T element$iv : $receiver$iv) {
                    JsName it;
                    JsName jsName = it = (JsName)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "it");
                    TemporaryAssignmentElimination.access$use(this.this$0, jsName);
                    JsName jsName2 = it;
                    Intrinsics.checkExpressionValueIsNotNull(jsName2, "it");
                    TemporaryAssignmentElimination.access$use(this.this$0, jsName2);
                }
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
        this.usages.keySet().retainAll((Collection)this.syntheticNames);
    }

    /*
     * WARNING - void declaration
     */
    private final Usage getUsage(JsName name) {
        void var3_3;
        Map<JsName, Usage> $receiver$iv = this.mappedUsages;
        Usage value$iv = $receiver$iv.get(name);
        if (value$iv == null) {
            Usage usage;
            if (Intrinsics.areEqual(this.usageCount.get(name), 1) ^ true) {
                return null;
            }
            Usage usage2 = this.usages.get(name);
            Usage usage3 = usage2;
            if (usage3 instanceof Usage.VariableAssignment) {
                Usage result2 = this.getUsage(((Usage.VariableAssignment)usage2).getTarget());
                if (result2 != null) {
                    result2.getStatements().addAll((Collection<JsStatement>)usage2.getStatements());
                    usage = result2;
                } else {
                    usage = usage2;
                }
            } else if (usage3 instanceof Usage.VariableDeclaration) {
                Usage result3 = this.getUsage(((Usage.VariableDeclaration)usage2).getTarget());
                if (result3 != null) {
                    result3.getStatements().addAll((Collection<JsStatement>)usage2.getStatements());
                    usage = result3;
                } else {
                    usage = usage2;
                }
            } else {
                usage = usage2;
            }
            return usage;
        }
        return (Usage)var3_3;
    }

    private final void calculateDeclarations() {
        Iterable $receiver$iv = this.usages.keySet();
        for (Object element$iv : $receiver$iv) {
            JsName it = (JsName)element$iv;
            this.getUsage(it);
        }
        new RecursiveJsVisitor(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    JsName jsName = assignment.getFirst();
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "assignment.first");
                    Usage usage = TemporaryAssignmentElimination.access$getUsage(this.this$0, jsName);
                    if (usage instanceof Usage.VariableDeclaration) {
                        Usage.VariableDeclaration variableDeclaration = (Usage.VariableDeclaration)usage;
                        int n = variableDeclaration.getCount();
                        variableDeclaration.setCount(n + 1);
                    }
                }
                super.visitExpressionStatement(x);
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    private final void process() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;

            /*
             * WARNING - void declaration
             */
            public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.removeMe();
                    return false;
                }
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    void name;
                    Pair<JsName, JsExpression> pair = assignment;
                    JsName jsName = pair.component1();
                    JsExpression jsExpression = pair.component2();
                    pair = null;
                    void v0 = name;
                    Intrinsics.checkExpressionValueIsNotNull(v0, "name");
                    Usage usage = TemporaryAssignmentElimination.access$getUsage(this.this$0, (JsName)v0);
                    if (usage != null) {
                        JsStatement jsStatement;
                        Object object;
                        void value;
                        Object object2 = usage;
                        if (object2 instanceof Usage.Return) {
                            object = new JsReturn((JsExpression)value);
                            JsReturn $receiver = object;
                            $receiver.source(x.getExpression().getSource());
                            jsStatement = (JsStatement)object;
                        } else if (object2 instanceof Usage.VariableAssignment) {
                            JsExpression expr = JsAstUtils.assignment(((Usage.VariableAssignment)usage).getTarget().makeRef(), (JsExpression)value).source(x.getExpression().getSource());
                            JsExpressionStatement statement = new JsExpressionStatement(expr);
                            MetadataProperties.setSynthetic(statement, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableAssignment)usage).getTarget()));
                            jsStatement = statement;
                        } else if (object2 instanceof Usage.VariableDeclaration) {
                            JsStatement statement;
                            JsStatement jsStatement2;
                            if (((Usage.VariableDeclaration)usage).getCount() > 1) {
                                JsExpression expr = JsAstUtils.assignment(((Usage.VariableDeclaration)usage).getTarget().makeRef(), (JsExpression)value).source(x.getExpression().getSource());
                                JsExpressionStatement result2 = new JsExpressionStatement(expr);
                                MetadataProperties.setSynthetic(result2, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableDeclaration)usage).getTarget()));
                                jsStatement2 = result2;
                            } else {
                                JsVars declaration = JsAstUtils.newVar(((Usage.VariableDeclaration)usage).getTarget(), (JsExpression)value);
                                declaration.source(x.getExpression().getSource());
                                MetadataProperties.setSynthetic(declaration, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableDeclaration)usage).getTarget()));
                                JsStatement jsStatement3 = declaration;
                                jsStatement2 = jsStatement3;
                                Intrinsics.checkExpressionValueIsNotNull(jsStatement3, "declaration");
                            }
                            jsStatement = statement = jsStatement2;
                        } else if (object2 instanceof Usage.PropertyMutation) {
                            jsStatement = new JsExpressionStatement(JsAstUtils.assignment(((Usage.PropertyMutation)usage).getTarget(), (JsExpression)value).source(x.getExpression().getSource()));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        JsStatement replacement = jsStatement;
                        TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                        ctx.replaceMe((JsNode)replacement);
                        object2 = TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0);
                        object = usage.getStatements();
                        CollectionsKt.addAll(object2, object);
                        return false;
                    }
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsReturn x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.removeMe();
                    return false;
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsVars x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.removeMe();
                    return false;
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    private final void generateDeclarations() {
        Object index2;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Sequence $receiver$iv = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.usages.values()), generateDeclarations.1.INSTANCE), generateDeclarations.2.INSTANCE);
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Usage.VariableDeclaration it = (Usage.VariableDeclaration)element$iv;
            JsVars statement = JsAstUtils.newVar(it.getTarget(), null);
            MetadataProperties.setSynthetic(statement, this.syntheticNames.contains(it.getTarget()));
            int n = index2.element;
            index2.element = n + 1;
            this.root.getStatements().add(n, statement);
        }
        index2 = null;
    }

    private final boolean tryRecord(JsExpression expr, Usage usage) {
        if (!(expr instanceof JsNameRef)) {
            return false;
        }
        JsName jsName = ((JsNameRef)expr).getName();
        if (jsName == null) {
            return false;
        }
        JsName name = jsName;
        if (this.namesToProcess.contains(name) ^ true) {
            return false;
        }
        Map<JsName, Usage> map2 = this.usages;
        JsName jsName2 = name;
        Intrinsics.checkExpressionValueIsNotNull(jsName2, "name");
        JsName jsName3 = jsName2;
        Usage usage2 = usage;
        map2.put(jsName3, usage2);
        return true;
    }

    private final void use(JsName name) {
        Map<JsName, Integer> map2 = this.usageCount;
        Integer n = this.usageCount.get(name);
        Integer n2 = 1 + (n != null ? ((Number)n).intValue() : 0);
        map2.put(name, n2);
    }

    public TemporaryAssignmentElimination(@NotNull JsBlock root) {
        Intrinsics.checkParameterIsNotNull(root, "root");
        this.root = root;
        this.usageCount = MapsKt.mutableMapOf(new Pair[0]);
        this.usages = MapsKt.mutableMapOf(new Pair[0]);
        this.statementsToRemove = SetsKt.mutableSetOf(new JsStatement[0]);
        this.mappedUsages = MapsKt.mutableMapOf(new Pair[0]);
        this.syntheticNames = SetsKt.mutableSetOf(new JsName[0]);
        this.namesToProcess = SetsKt.mutableSetOf(new JsName[0]);
    }

    public static final /* synthetic */ boolean access$tryRecord(TemporaryAssignmentElimination $this, @NotNull JsExpression expr, @NotNull Usage usage) {
        return $this.tryRecord(expr, usage);
    }

    @NotNull
    public static final /* synthetic */ Set access$getSyntheticNames$p(TemporaryAssignmentElimination $this) {
        return $this.syntheticNames;
    }

    public static final /* synthetic */ void access$use(TemporaryAssignmentElimination $this, @NotNull JsName name) {
        $this.use(name);
    }

    @Nullable
    public static final /* synthetic */ Usage access$getUsage(TemporaryAssignmentElimination $this, @NotNull JsName name) {
        return $this.getUsage(name);
    }

    @NotNull
    public static final /* synthetic */ Set access$getStatementsToRemove$p(TemporaryAssignmentElimination $this) {
        return $this.statementsToRemove;
    }

    public static final /* synthetic */ boolean access$getHasChanges$p(TemporaryAssignmentElimination $this) {
        return $this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(TemporaryAssignmentElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0007\b2\u0018\u00002\u00020\u0001:\u0004\t\n\u000b\fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "", "statement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "(Lcom/google/dart/compiler/backend/js/ast/JsStatement;)V", "statements", "", "getStatements", "()Ljava/util/Set;", "PropertyMutation", "Return", "VariableAssignment", "VariableDeclaration", "kotlin-compiler"})
    private static abstract class Usage {
        @NotNull
        private final Set<JsStatement> statements;

        @NotNull
        public final Set<JsStatement> getStatements() {
            return this.statements;
        }

        private Usage(JsStatement statement) {
            this.statements = SetsKt.mutableSetOf(statement);
        }

        public /* synthetic */ Usage(@NotNull JsStatement statement, DefaultConstructorMarker $constructor_marker) {
            this(statement);
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$Return;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "(Lcom/google/dart/compiler/backend/js/ast/JsStatement;)V", "kotlin-compiler"})
        public static final class Return
        extends Usage {
            public Return(@NotNull JsStatement statement) {
                Intrinsics.checkParameterIsNotNull(statement, "statement");
                super(statement, null);
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableAssignment;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "(Lcom/google/dart/compiler/backend/js/ast/JsStatement;Lcom/google/dart/compiler/backend/js/ast/JsName;)V", "getTarget", "()Lcom/google/dart/compiler/backend/js/ast/JsName;", "kotlin-compiler"})
        public static final class VariableAssignment
        extends Usage {
            @NotNull
            private final JsName target;

            @NotNull
            public final JsName getTarget() {
                return this.target;
            }

            public VariableAssignment(@NotNull JsStatement statement, @NotNull JsName target) {
                Intrinsics.checkParameterIsNotNull(statement, "statement");
                Intrinsics.checkParameterIsNotNull(target, "target");
                super(statement, null);
                this.target = target;
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableDeclaration;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "(Lcom/google/dart/compiler/backend/js/ast/JsStatement;Lcom/google/dart/compiler/backend/js/ast/JsName;)V", "count", "", "getCount", "()I", "setCount", "(I)V", "getTarget", "()Lcom/google/dart/compiler/backend/js/ast/JsName;", "kotlin-compiler"})
        public static final class VariableDeclaration
        extends Usage {
            private int count;
            @NotNull
            private final JsName target;

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            @NotNull
            public final JsName getTarget() {
                return this.target;
            }

            public VariableDeclaration(@NotNull JsStatement statement, @NotNull JsName target) {
                Intrinsics.checkParameterIsNotNull(statement, "statement");
                Intrinsics.checkParameterIsNotNull(target, "target");
                super(statement, null);
                this.target = target;
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$PropertyMutation;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "(Lcom/google/dart/compiler/backend/js/ast/JsStatement;Lcom/google/dart/compiler/backend/js/ast/JsExpression;)V", "getTarget", "()Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "kotlin-compiler"})
        public static final class PropertyMutation
        extends Usage {
            @NotNull
            private final JsExpression target;

            @NotNull
            public final JsExpression getTarget() {
                return this.target;
            }

            public PropertyMutation(@NotNull JsStatement statement, @NotNull JsExpression target) {
                Intrinsics.checkParameterIsNotNull(statement, "statement");
                Intrinsics.checkParameterIsNotNull(target, "target");
                super(statement, null);
                this.target = target;
            }
        }
    }
}

