/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxedValuesCollection;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableSet;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0017J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0013H\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0014J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0013H\u0014J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0013H\u0014J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u001a\u0010\u001d\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nJ*\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010!\u001a\u00020\nH\u0017J\u001a\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;)V", "candidatesBoxedValues", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection;", "getCandidatesBoxedValues", "()Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection;", "binaryOperation", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "value1", "value2", "copyOperation", "value", "markValueAsDirty", "", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "onMergeFail", "onMergeSuccess", "v", "w", "onMethodCallWithBoxedValue", "onNewBoxedValue", "onUnboxing", "resultType", "Lorg/jetbrains/org/objectweb/asm/Type;", "processOperationWithBoxedValue", "insnNode", "processPopInstruction", "ternaryOperation", "value3", "unaryOperation", "Companion", "kotlin-compiler"})
public final class RedundantBoxingInterpreter
extends BoxingInterpreter {
    @NotNull
    private final RedundantBoxedValuesCollection candidatesBoxedValues;
    private static final ImmutableSet<Integer> PERMITTED_OPERATIONS_OPCODES;
    private static final ImmutableSet<Integer> PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER;
    public static final Companion Companion;

    @NotNull
    public final RedundantBoxedValuesCollection getCandidatesBoxedValues() {
        return this.candidatesBoxedValues;
    }

    @Override
    @Nullable
    public BasicValue binaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2) throws AnalyzerException {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value1, "value1");
        Intrinsics.checkParameterIsNotNull(value2, "value2");
        this.processOperationWithBoxedValue(value1, insn);
        this.processOperationWithBoxedValue(value2, insn);
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    @Nullable
    public BasicValue ternaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2, @NotNull BasicValue value3) throws AnalyzerException {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value1, "value1");
        Intrinsics.checkParameterIsNotNull(value2, "value2");
        Intrinsics.checkParameterIsNotNull(value3, "value3");
        this.processOperationWithBoxedValue(value3, insn);
        return super.ternaryOperation(insn, value1, value2, value3);
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value) throws AnalyzerException {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value, "value");
        if ((insn.getOpcode() == 192 || insn.getOpcode() == 193) && value instanceof BoxedBasicValue) {
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TypeInsnNode");
            }
            TypeInsnNode typeInsn = (TypeInsnNode)abstractInsnNode;
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)value;
            String string = typeInsn.desc;
            Intrinsics.checkExpressionValueIsNotNull(string, "typeInsn.desc");
            if (!RedundantBoxingInterpreter.Companion.isSafeCast(boxedBasicValue, string)) {
                this.markValueAsDirty((BoxedBasicValue)value);
            }
        }
        this.processOperationWithBoxedValue(value, insn);
        return super.unaryOperation(insn, value);
    }

    @Override
    @NotNull
    public BasicValue copyOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value) throws AnalyzerException {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value, "value");
        if (value instanceof BoxedBasicValue && insn.getOpcode() == 58) {
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
            }
            ((BoxedBasicValue)value).addVariableIndex(((VarInsnNode)abstractInsnNode).var);
        }
        this.processOperationWithBoxedValue(value, insn);
        BasicValue basicValue = super.copyOperation(insn, value);
        Intrinsics.checkExpressionValueIsNotNull(basicValue, "super.copyOperation(insn, value)");
        return basicValue;
    }

    public final void processPopInstruction(@NotNull AbstractInsnNode insnNode, @NotNull BasicValue value) {
        Intrinsics.checkParameterIsNotNull(insnNode, "insnNode");
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.processOperationWithBoxedValue(value, insnNode);
    }

    @Override
    protected void onNewBoxedValue(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.candidatesBoxedValues.add(value);
    }

    @Override
    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value, @NotNull Type resultType) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(resultType, "resultType");
        if (Intrinsics.areEqual(value.getPrimitiveType(), resultType)) {
            RedundantBoxingInterpreter.Companion.addAssociatedInsn(value, insn);
        } else {
            value.addUnboxingWithCastTo(insn, resultType);
        }
    }

    @Override
    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.markValueAsDirty(value);
    }

    @Override
    protected void onMergeFail(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.markValueAsDirty(value);
    }

    @Override
    protected void onMergeSuccess(@NotNull BoxedBasicValue v, @NotNull BoxedBasicValue w) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull(w, "w");
        this.candidatesBoxedValues.merge(v, w);
    }

    private final void processOperationWithBoxedValue(BasicValue value, AbstractInsnNode insnNode) {
        if (value instanceof BoxedBasicValue) {
            if (!RedundantBoxingInterpreter.Companion.getPERMITTED_OPERATIONS_OPCODES().contains(insnNode.getOpcode())) {
                this.markValueAsDirty((BoxedBasicValue)value);
            } else {
                RedundantBoxingInterpreter.Companion.addAssociatedInsn((BoxedBasicValue)value, insnNode);
            }
        }
    }

    private final void markValueAsDirty(BoxedBasicValue value) {
        this.candidatesBoxedValues.remove(value);
    }

    public RedundantBoxingInterpreter(@NotNull InsnList insnList) {
        Intrinsics.checkParameterIsNotNull(insnList, "insnList");
        super(insnList);
        this.candidatesBoxedValues = new RedundantBoxedValuesCollection();
    }

    static {
        Companion = new Companion(null);
        PERMITTED_OPERATIONS_OPCODES = ImmutableSet.of(Integer.valueOf(58), Integer.valueOf(25), Integer.valueOf(87), Integer.valueOf(89), Integer.valueOf(192), Integer.valueOf(193), new Integer[0]);
        PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER = ImmutableSet.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), new Integer[0]);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR8\u0010\t\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter$Companion;", "", "()V", "PERMITTED_OPERATIONS_OPCODES", "Lorg/jetbrains/kotlin/relocated/com/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "getPERMITTED_OPERATIONS_OPCODES", "()Lcom/google/common/collect/ImmutableSet;", "PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER", "getPRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER", "addAssociatedInsn", "", "value", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isSafeCast", "", "targetInternalName", "", "kotlin-compiler"})
    public static final class Companion {
        private final ImmutableSet<Integer> getPERMITTED_OPERATIONS_OPCODES() {
            return PERMITTED_OPERATIONS_OPCODES;
        }

        private final ImmutableSet<Integer> getPRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER() {
            return PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER;
        }

        private final boolean isSafeCast(BoxedBasicValue value, String targetInternalName) {
            String string = targetInternalName;
            return Intrinsics.areEqual(string, Type.getInternalName(Object.class)) ? true : (Intrinsics.areEqual(string, Type.getInternalName(Number.class)) ? this.getPRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER().contains(value.getPrimitiveType().getSort()) : value.getType().getInternalName().equals(targetInternalName));
        }

        private final void addAssociatedInsn(BoxedBasicValue value, AbstractInsnNode insn) {
            if (value.isSafeToRemove()) {
                value.addInsn(insn);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

