/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import sun.reflect.ConstructorAccessor;

public class StringFactory {
    private static final ConstructorAccessor ourConstructorAccessor;

    @NotNull
    public static String createShared(@NotNull char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/StringFactory", "createShared"));
        }
        if (ourConstructorAccessor != null) {
            String string = (String)ReflectionUtil.createInstanceViaConstructorAccessor(ourConstructorAccessor, chars, Boolean.TRUE);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/StringFactory", "createShared"));
            }
            return string;
        }
        String string = new String(chars);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/StringFactory", "createShared"));
        }
        return string;
    }

    static {
        ConstructorAccessor constructorAccessor = null;
        try {
            Constructor newC = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            constructorAccessor = ReflectionUtil.getConstructorAccessor(newC);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ourConstructorAccessor = constructorAccessor;
    }
}

