/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class ClassPresentationUtil {
    private ClassPresentationUtil() {
    }

    public static String getNameForClass(@NotNull PsiClass aClass2, boolean qualified) {
        String qName;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/presentation/java/ClassPresentationUtil", "getNameForClass"));
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            if (aClass2 instanceof PsiEnumConstantInitializer) {
                PsiEnumConstant enumConstant = ((PsiEnumConstantInitializer)aClass2).getEnumConstant();
                String name = enumConstant.getName();
                return PsiBundle.message("enum.constant.context", name, ClassPresentationUtil.getContextName(enumConstant, qualified));
            }
            return PsiBundle.message("anonymous.class.context.display", ClassPresentationUtil.getContextName(aClass2, qualified));
        }
        if (qualified && (qName = aClass2.getQualifiedName()) != null) {
            return qName;
        }
        String className2 = aClass2.getName();
        String contextName = ClassPresentationUtil.getContextName(aClass2, qualified);
        return contextName != null ? PsiBundle.message("class.context.display", className2, contextName) : className2;
    }

    private static String getNameForElement(@NotNull PsiElement element, boolean qualified) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/presentation/java/ClassPresentationUtil", "getNameForElement"));
        }
        if (element instanceof PsiClass) {
            return ClassPresentationUtil.getNameForClass((PsiClass)element, qualified);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String methodName = method.getName();
            return PsiBundle.message("method.context.display", methodName, ClassPresentationUtil.getContextName(method, qualified));
        }
        if (element instanceof PsiClassOwner) {
            return null;
        }
        if (element instanceof PsiFile) {
            return ((PsiFile)element).getName();
        }
        if (element instanceof PsiField) {
            return ((PsiField)element).getName();
        }
        return null;
    }

    public static String getContextName(@NotNull PsiElement element, boolean qualified) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/presentation/java/ClassPresentationUtil", "getContextName"));
        }
        PsiElement parent2 = PsiTreeUtil.getStubOrPsiParentOfType(element, PsiMember.class);
        if (parent2 == null) {
            parent2 = element.getContainingFile();
        }
        while (parent2 != null) {
            String name = ClassPresentationUtil.getNameForElement(parent2, qualified);
            if (name != null) {
                return name;
            }
            if (parent2 instanceof PsiFile) {
                return null;
            }
            parent2 = PsiTreeUtil.getStubOrPsiParent(parent2);
        }
        return null;
    }

    public static String getFunctionalExpressionPresentation(PsiFunctionalExpression functionalExpression, boolean qualified) {
        return "Functional expression in " + ClassPresentationUtil.getContextName(functionalExpression, qualified);
    }
}

