/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import com.intellij.util.xmlb.XmlSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.org.jdom.Element;
import org.jetbrains.kotlin.relocated.org.picocontainer.ComponentAdapter;
import org.jetbrains.kotlin.relocated.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.relocated.org.picocontainer.PicoException;
import org.jetbrains.kotlin.relocated.org.picocontainer.PicoInitializationException;

public class ExtensionComponentAdapter
implements LoadingOrder.Orderable,
AssignableToComponentAdapter {
    public static final ExtensionComponentAdapter[] EMPTY_ARRAY = new ExtensionComponentAdapter[0];
    private Object myComponentInstance;
    private final String myImplementationClassName;
    private final Element myExtensionElement;
    private final PicoContainer myContainer;
    private final PluginDescriptor myPluginDescriptor;
    private final boolean myDeserializeInstance;
    private ComponentAdapter myDelegate;
    private Class myImplementationClass;
    private boolean myNotificationSent;

    public ExtensionComponentAdapter(@NotNull String implementationClass, Element extensionElement, PicoContainer container2, PluginDescriptor pluginDescriptor, boolean deserializeInstance) {
        if (implementationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementationClass", "com/intellij/openapi/extensions/impl/ExtensionComponentAdapter", "<init>"));
        }
        this.myNotificationSent = false;
        this.myImplementationClassName = implementationClass;
        this.myExtensionElement = extensionElement;
        this.myContainer = container2;
        this.myPluginDescriptor = pluginDescriptor;
        this.myDeserializeInstance = deserializeInstance;
    }

    @Override
    public Object getComponentKey() {
        return this;
    }

    @Override
    public Class getComponentImplementation() {
        return this.loadImplementationClass();
    }

    @Override
    public Object getComponentInstance(PicoContainer container2) throws PicoException, ProcessCanceledException {
        if (this.myComponentInstance == null) {
            block9: {
                try {
                    if (Element.class.equals((Object)this.getComponentImplementation())) {
                        this.myComponentInstance = this.myExtensionElement;
                        break block9;
                    }
                    Object componentInstance = this.getDelegate().getComponentInstance(container2);
                    if (this.myDeserializeInstance) {
                        try {
                            XmlSerializer.deserializeInto(componentInstance, this.myExtensionElement);
                        }
                        catch (Exception e) {
                            throw new PicoInitializationException(e);
                        }
                    }
                    this.myComponentInstance = componentInstance;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    PluginId pluginId = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginId() : null;
                    throw new PicoPluginExtensionInitializationException(t.getMessage(), t, pluginId);
                }
            }
            if (this.myComponentInstance instanceof PluginAware) {
                PluginAware pluginAware = (PluginAware)this.myComponentInstance;
                pluginAware.setPluginDescriptor(this.myPluginDescriptor);
            }
        }
        return this.myComponentInstance;
    }

    public Object getExtension() {
        return this.getComponentInstance(this.myContainer);
    }

    @Override
    public LoadingOrder getOrder() {
        return LoadingOrder.readOrder(this.myExtensionElement.getAttributeValue("order"));
    }

    @Override
    public String getOrderId() {
        return this.myExtensionElement.getAttributeValue("id");
    }

    private Element getExtensionElement() {
        return this.myExtensionElement;
    }

    @Override
    public Element getDescribingElement() {
        return this.getExtensionElement();
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @NotNull
    private Class loadImplementationClass() {
        if (this.myImplementationClass == null) {
            try {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginClassLoader() : this.getClass().getClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                this.myImplementationClass = Class.forName(this.myImplementationClassName, false, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class clazz = this.myImplementationClass;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionComponentAdapter", "loadImplementationClass"));
        }
        return clazz;
    }

    private synchronized ComponentAdapter getDelegate() {
        if (this.myDelegate == null) {
            Class impl = this.loadImplementationClass();
            this.myDelegate = new ConstructorInjectionComponentAdapter(this.getComponentKey(), impl, null, true);
        }
        return this.myDelegate;
    }

    @Override
    public String getAssignableToClassName() {
        return this.myImplementationClassName;
    }

    public boolean isNotificationSent() {
        return this.myNotificationSent;
    }

    public void setNotificationSent(boolean notificationSent) {
        this.myNotificationSent = notificationSent;
    }

    public String toString() {
        return "ExtensionComponentAdapter[" + this.myImplementationClassName + "]: plugin=" + this.myPluginDescriptor;
    }
}

