/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.CompositeScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ExplicitReceiverScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.NoExplicitReceiverScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.QualifierScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.TowerContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a]\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062/\u0010\b\u001a+\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r0\t\u00a2\u0006\u0002\b\u000fH\u0002\u001a*\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0011"}, d2={"createFunctionProcessor", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "C", "context", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerContext;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "createSimpleProcessor", "collectCandidates", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerLevel;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "Lkotlin/ExtensionFunctionType;", "createVariableProcessor", "kotlin-compiler"})
public final class ScopeTowerProcessorsKt {
    private static final <C> ScopeTowerProcessor<C> createSimpleProcessor(TowerContext<C> context, Receiver explicitReceiver, Function3<? super ScopeTowerLevel, ? super Name, ? super ReceiverValue, ? extends Collection<? extends CandidateWithBoundDispatchReceiver<?>>> collectCandidates) {
        Unit unit;
        if (explicitReceiver instanceof ReceiverValue) {
            return new ExplicitReceiverScopeTowerProcessor<C>(context, (ReceiverValue)explicitReceiver, collectCandidates);
        }
        if (explicitReceiver instanceof QualifierReceiver) {
            QualifierScopeTowerProcessor<C> qualifierProcessor = new QualifierScopeTowerProcessor<C>(context, (QualifierReceiver)explicitReceiver, collectCandidates);
            ReceiverValue receiverValue = ((QualifierReceiver)explicitReceiver).getClassValueReceiver();
            if (receiverValue == null) {
                return qualifierProcessor;
            }
            ReceiverValue classValue = receiverValue;
            return new CompositeScopeTowerProcessor(qualifierProcessor, new ExplicitReceiverScopeTowerProcessor<C>(context, classValue, collectCandidates));
        }
        boolean bl = explicitReceiver == null;
        if (_Assertions.ENABLED) {
            if (!bl) {
                StringBuilder stringBuilder = new StringBuilder().append("Illegal explicit receiver: ").append(explicitReceiver).append("(");
                Receiver receiver = explicitReceiver;
                if (receiver == null) {
                    Intrinsics.throwNpe();
                }
                String string = stringBuilder.append(receiver.getClass().getSimpleName()).append(")").toString();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return new NoExplicitReceiverScopeTowerProcessor<C>(context, collectCandidates);
    }

    @NotNull
    public static final <C> ScopeTowerProcessor<C> createVariableProcessor(@NotNull TowerContext<C> context, @Nullable Receiver explicitReceiver) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        return ScopeTowerProcessorsKt.createSimpleProcessor(context, explicitReceiver, createVariableProcessor.1.INSTANCE);
    }

    @NotNull
    public static final <C> ScopeTowerProcessor<C> createFunctionProcessor(@NotNull TowerContext<C> context, @Nullable Receiver explicitReceiver) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        return ScopeTowerProcessorsKt.createSimpleProcessor(context, explicitReceiver, createFunctionProcessor.1.INSTANCE);
    }
}

