/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.VariableTypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J2\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ(\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J/\u0010&\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b*R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "variableTypeResolver", "Lorg/jetbrains/kotlin/resolve/VariableTypeResolver;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/VariableTypeResolver;)V", "initializeWithDefaultGetterSetter", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl;", "process", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "typingContext", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingFacade;", "resolveLocalVariableDescriptor", "variable", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveLocalVariableDescriptorWithType", "Lorg/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveLocalVariableDescriptorWithType$kotlin_compiler", "kotlin-compiler"})
public final class LocalVariableResolver {
    private final ExpressionTypingServices expressionTypingServices;
    private final ModifiersChecker modifiersChecker;
    private final IdentifierChecker identifierChecker;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final AnnotationResolver annotationResolver;
    private final VariableTypeResolver variableTypeResolver;

    @NotNull
    public final Pair<KotlinTypeInfo, VariableDescriptor> process(@NotNull KtProperty property, @NotNull ExpressionTypingContext typingContext, @NotNull LexicalScope scope2, @NotNull ExpressionTypingFacade facade) {
        KotlinTypeInfo typeInfo;
        KtExpression delegateExpression;
        KtPropertyAccessor setter;
        KtPropertyAccessor getter;
        Intrinsics.checkParameterIsNotNull(property, "property");
        Intrinsics.checkParameterIsNotNull(typingContext, "typingContext");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceScope(scope2);
        KtTypeReference receiverTypeRef = property.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            context.trace.report(Errors.LOCAL_EXTENSION_PROPERTY.on((KtTypeReference)((PsiElement)receiverTypeRef)));
        }
        if ((getter = property.getGetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter)));
        }
        if ((setter = property.getSetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter)));
        }
        if ((delegateExpression = property.getDelegateExpression()) != null) {
            this.expressionTypingServices.getTypeInfo(delegateExpression, context);
            BindingTrace bindingTrace = context.trace;
            KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
            if (ktPropertyDelegate == null) {
                Intrinsics.throwNpe();
            }
            bindingTrace.report(Errors.LOCAL_VARIABLE_WITH_DELEGATE.on((KtPropertyDelegate)((PsiElement)ktPropertyDelegate)));
        }
        KtVariableDeclaration ktVariableDeclaration = property;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        VariableDescriptor propertyDescriptor = this.resolveLocalVariableDescriptor(scope2, ktVariableDeclaration, dataFlowInfo, bindingTrace);
        KtExpression initializer2 = property.getInitializer();
        if (initializer2 != null) {
            KotlinType outType = propertyDescriptor.getType();
            KotlinTypeInfo kotlinTypeInfo = facade.getTypeInfo(initializer2, (ExpressionTypingContext)context.replaceExpectedType(outType));
            Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "facade.getTypeInfo(initi\u2026aceExpectedType(outType))");
            typeInfo = kotlinTypeInfo;
            DataFlowInfo dataFlowInfo2 = typeInfo.getDataFlowInfo();
            KotlinType type2 = typeInfo.getType();
            if (property.getTypeReference() == null && type2 != null) {
                DataFlowValue variableDataFlowValue = DataFlowValueFactory.createDataFlowValueForProperty(property, propertyDescriptor, context.trace.getBindingContext(), DescriptorUtils.getContainingModuleOrNull(scope2.getOwnerDescriptor()));
                DataFlowValue initializerDataFlowValue = DataFlowValueFactory.createDataFlowValue(initializer2, type2, context);
                DataFlowValue dataFlowValue = variableDataFlowValue;
                Intrinsics.checkExpressionValueIsNotNull(dataFlowValue, "variableDataFlowValue");
                DataFlowValue dataFlowValue2 = initializerDataFlowValue;
                Intrinsics.checkExpressionValueIsNotNull(dataFlowValue2, "initializerDataFlowValue");
                typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo2.assign(dataFlowValue, dataFlowValue2));
            }
        } else {
            ResolutionContext resolutionContext = context;
            Intrinsics.checkExpressionValueIsNotNull(resolutionContext, "context");
            typeInfo = TypeInfoFactoryKt.noTypeInfo(resolutionContext);
        }
        ExpressionTypingUtils.checkVariableShadowing(context.scope, context.trace, propertyDescriptor);
        KtDeclaration ktDeclaration = property;
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
        DeclarationsCheckerKt.checkTypeReferences(ktDeclaration, bindingTrace2);
        this.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(property, propertyDescriptor);
        KtDeclaration ktDeclaration2 = property;
        DiagnosticSink diagnosticSink = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "context.trace");
        this.identifierChecker.checkDeclaration(ktDeclaration2, diagnosticSink);
        return new Pair<KotlinTypeInfo, VariableDescriptor>(typeInfo.replaceType(this.dataFlowAnalyzer.checkStatementType(property, context)), propertyDescriptor);
    }

    private final VariableDescriptor resolveLocalVariableDescriptor(LexicalScope scope2, KtVariableDeclaration variable, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        VariableDescriptor result2;
        KotlinType type2;
        DeclarationDescriptor containingDeclaration = scope2.getOwnerDescriptor();
        if (KtPsiUtil.isScriptDeclaration(variable)) {
            PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(containingDeclaration, this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable.getModifierList(), trace), Modality.FINAL, Visibilities.INTERNAL, variable.isVar(), KtPsiUtil.safeName(variable.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(variable), false, false);
            VariableDescriptorWithInitializerImpl variableDescriptorWithInitializerImpl = propertyDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptorWithInitializerImpl, "propertyDescriptor");
            type2 = this.variableTypeResolver.process(variableDescriptorWithInitializerImpl, scope2, variable, dataFlowInfo, false, trace);
            DeclarationDescriptor declarationDescriptor = containingDeclaration;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ScriptDescriptor");
            }
            ReceiverParameterDescriptor receiverParameter = ((ScriptDescriptor)declarationDescriptor).getThisAsReceiverParameter();
            List list2 = CollectionsKt.emptyList();
            Object v3 = null;
            if (!(null instanceof KotlinType)) {
                v3 = null;
            }
            propertyDescriptor.setType(type2, list2, receiverParameter, (KotlinType)v3);
            PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptorImpl, "propertyDescriptor");
            this.initializeWithDefaultGetterSetter(propertyDescriptorImpl);
            trace.record(BindingContext.VARIABLE, variable, propertyDescriptor);
            PropertyDescriptorImpl propertyDescriptorImpl2 = propertyDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptorImpl2, "propertyDescriptor");
            result2 = propertyDescriptorImpl2;
        } else {
            LocalVariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptorWithType$kotlin_compiler(scope2, variable, null, trace);
            type2 = this.variableTypeResolver.process(variableDescriptor, scope2, variable, dataFlowInfo, false, trace);
            variableDescriptor.setOutType(type2);
            result2 = variableDescriptor;
        }
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        return result2;
    }

    private final void initializeWithDefaultGetterSetter(PropertyDescriptorImpl propertyDescriptor) {
        PropertySetterDescriptor setter;
        PropertyGetterDescriptorImpl getter = propertyDescriptor.getGetter();
        if (getter == null && !Visibilities.isPrivate(propertyDescriptor.getVisibility())) {
            getter = DescriptorFactory.createDefaultGetter(propertyDescriptor, Annotations.Companion.getEMPTY());
            getter.initialize(propertyDescriptor.getType());
        }
        if ((setter = propertyDescriptor.getSetter()) == null && propertyDescriptor.isVar()) {
            setter = DescriptorFactory.createDefaultSetter(propertyDescriptor, Annotations.Companion.getEMPTY());
        }
        propertyDescriptor.initialize(getter, setter);
    }

    @NotNull
    public final LocalVariableDescriptor resolveLocalVariableDescriptorWithType$kotlin_compiler(@NotNull LexicalScope scope2, @NotNull KtVariableDeclaration variable, @Nullable KotlinType type2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable.getModifierList(), trace), KtPsiUtil.safeName(variable.getName()), type2, variable.isVar(), KotlinSourceElementKt.toSourceElement(variable));
        trace.record(BindingContext.VARIABLE, variable, variableDescriptor);
        return variableDescriptor;
    }

    public LocalVariableResolver(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull ModifiersChecker modifiersChecker, @NotNull IdentifierChecker identifierChecker, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull AnnotationResolver annotationResolver, @NotNull VariableTypeResolver variableTypeResolver) {
        Intrinsics.checkParameterIsNotNull(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkParameterIsNotNull(modifiersChecker, "modifiersChecker");
        Intrinsics.checkParameterIsNotNull(identifierChecker, "identifierChecker");
        Intrinsics.checkParameterIsNotNull(dataFlowAnalyzer, "dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(variableTypeResolver, "variableTypeResolver");
        this.expressionTypingServices = expressionTypingServices;
        this.modifiersChecker = modifiersChecker;
        this.identifierChecker = identifierChecker;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.annotationResolver = annotationResolver;
        this.variableTypeResolver = variableTypeResolver;
    }
}

