/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/LibrarySourceHacks;", "", "()V", "SKIP_TOP_LEVEL_MEMBERS", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/Key;", "", "getSKIP_TOP_LEVEL_MEMBERS", "()Lcom/intellij/openapi/util/Key;", "shouldSkip", "member", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "kotlin-compiler"})
public final class LibrarySourceHacks {
    @NotNull
    private static final Key<Boolean> SKIP_TOP_LEVEL_MEMBERS;
    public static final LibrarySourceHacks INSTANCE;

    @NotNull
    public final Key<Boolean> getSKIP_TOP_LEVEL_MEMBERS() {
        return SKIP_TOP_LEVEL_MEMBERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldSkip(@NotNull CallableDescriptor member) {
        Intrinsics.checkParameterIsNotNull(member, "member");
        CallableDescriptor callableDescriptor = member.getOriginal();
        if (!(callableDescriptor instanceof CallableMemberDescriptor)) {
            callableDescriptor = null;
        }
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)callableDescriptor;
        if (callableMemberDescriptor == null) return false;
        CallableMemberDescriptor original = callableMemberDescriptor;
        if (!(original.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
            return false;
        }
        PsiElement psiElement = DescriptorToSourceUtils.getSourceFromDescriptor(original);
        if (psiElement == null) return false;
        PsiElement declaration = psiElement;
        PsiFile file = declaration.getContainingFile();
        if (file == null) return false;
        Boolean bl = file.getUserData(SKIP_TOP_LEVEL_MEMBERS);
        if (bl == null) return false;
        boolean bl2 = bl;
        if (!bl2) return false;
        return true;
    }

    private LibrarySourceHacks() {
        INSTANCE = this;
        Key key = Key.create("SKIP_TOP_LEVEL_MEMBERS");
        Intrinsics.checkExpressionValueIsNotNull(key, "Key.create<Boolean>(\"SKIP_TOP_LEVEL_MEMBERS\")");
        SKIP_TOP_LEVEL_MEMBERS = key;
    }

    static {
        new LibrarySourceHacks();
    }
}

