/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinParameterStubImpl;

public class KtParameterElementType
extends KtStubElementType<KotlinParameterStub, KtParameter> {
    public KtParameterElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/psi/stubs/elements/KtParameterElementType", "<init>"));
        }
        super(debugName, KtParameter.class, KotlinParameterStub.class);
    }

    @Override
    public KotlinParameterStub createStub(@NotNull KtParameter psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/psi/stubs/elements/KtParameterElementType", "createStub"));
        }
        FqName fqName2 = psi.getFqName();
        StringRef fqNameRef = StringRef.fromString(fqName2 != null ? fqName2.asString() : null);
        return new KotlinParameterStubImpl(parentStub, fqNameRef, StringRef.fromString(psi.getName()), psi.isMutable(), psi.hasValOrVar(), psi.hasDefaultValue());
    }

    @Override
    public void serialize(@NotNull KotlinParameterStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/KtParameterElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/KtParameterElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isMutable());
        dataStream.writeBoolean(stub.hasValOrVar());
        dataStream.writeBoolean(stub.hasDefaultValue());
        FqName name = stub.getFqName();
        dataStream.writeName(name != null ? name.asString() : null);
    }

    @Override
    @NotNull
    public KotlinParameterStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/KtParameterElementType", "deserialize"));
        }
        StringRef name = dataStream.readName();
        boolean isMutable = dataStream.readBoolean();
        boolean hasValOrValNode = dataStream.readBoolean();
        boolean hasDefaultValue2 = dataStream.readBoolean();
        StringRef fqName2 = dataStream.readName();
        KotlinParameterStubImpl kotlinParameterStubImpl = new KotlinParameterStubImpl(parentStub, fqName2, name, isMutable, hasValOrValNode, hasDefaultValue2);
        if (kotlinParameterStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtParameterElementType", "deserialize"));
        }
        return kotlinParameterStubImpl;
    }
}

