/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImplStub;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpressionImpl;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtDotQualifiedExpression
extends KtExpressionImplStub<KotlinPlaceHolderStub<KtDotQualifiedExpression>>
implements KtQualifiedExpression {
    private static final Logger LOG = Logger.getInstance(KtDotQualifiedExpression.class);

    public KtDotQualifiedExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtDotQualifiedExpression", "<init>"));
        }
        super(node);
    }

    public KtDotQualifiedExpression(@NotNull KotlinPlaceHolderStub<KtDotQualifiedExpression> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtDotQualifiedExpression", "<init>"));
        }
        super(stub, KtStubElementTypes.DOT_QUALIFIED_EXPRESSION);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtDotQualifiedExpression", "accept"));
        }
        return visitor2.visitDotQualifiedExpression(this, data);
    }

    @Override
    @NotNull
    public KtExpression getReceiverExpression() {
        KtExpression[] childExpressionsByStub;
        KotlinPlaceHolderStub stub = (KotlinPlaceHolderStub)this.getStub();
        if (stub != null && (childExpressionsByStub = this.getChildExpressionsByStub(stub)) != null) {
            KtExpression ktExpression = childExpressionsByStub[0];
            if (ktExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDotQualifiedExpression", "getReceiverExpression"));
            }
            return ktExpression;
        }
        KtExpression ktExpression = KtQualifiedExpressionImpl.INSTANCE.getReceiverExpression(this);
        if (ktExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDotQualifiedExpression", "getReceiverExpression"));
        }
        return ktExpression;
    }

    @Override
    @Nullable
    public KtExpression getSelectorExpression() {
        KtExpression[] childExpressionsByStub;
        KotlinPlaceHolderStub stub = (KotlinPlaceHolderStub)this.getStub();
        if (stub != null && (childExpressionsByStub = this.getChildExpressionsByStub(stub)) != null && childExpressionsByStub.length == 2) {
            return childExpressionsByStub[1];
        }
        return KtQualifiedExpressionImpl.INSTANCE.getSelectorExpression(this);
    }

    @Nullable
    private KtExpression[] getChildExpressionsByStub(@NotNull KotlinPlaceHolderStub<KtDotQualifiedExpression> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtDotQualifiedExpression", "getChildExpressionsByStub"));
        }
        if (stub.getParentStubOfType(KtImportDirective.class) == null && stub.getParentStubOfType(KtPackageDirective.class) == null) {
            LOG.error("JetDotQualifiedExpression should only have stubs inside import or package directives.\n Stubs were created for:\n " + this.getText() + "\nFile text:\n" + this.getContainingFile().getText());
            return null;
        }
        KtExpression[] expressions = (KtExpression[])stub.getChildrenByType(KtStubElementTypes.INSIDE_DIRECTIVE_EXPRESSIONS, KtExpression.ARRAY_FACTORY);
        if (expressions.length < 1 || expressions.length > 2) {
            LOG.error("Invalid stub structure. DOT_QUALIFIED_EXPRESSION must have one or two children. Was: " + expressions.length + "\nFile text:\n" + this.getContainingFile().getText());
            return null;
        }
        return expressions;
    }

    @Override
    @NotNull
    public ASTNode getOperationTokenNode() {
        ASTNode aSTNode = KtQualifiedExpressionImpl.INSTANCE.getOperationTokenNode(this);
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDotQualifiedExpression", "getOperationTokenNode"));
        }
        return aSTNode;
    }

    @Override
    @NotNull
    public KtToken getOperationSign() {
        KtToken ktToken = KtQualifiedExpressionImpl.INSTANCE.getOperationSign(this);
        if (ktToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDotQualifiedExpression", "getOperationSign"));
        }
        return ktToken;
    }
}

