/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.KotlinFunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.ManglingUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

public final class TopLevelFIF
extends CompositeFIF {
    public static final DescriptorPredicate EQUALS_IN_ANY = PatternBuilder.pattern("kotlin", "Any", "equals");
    @NotNull
    private static final KotlinFunctionIntrinsic KOTLIN_ANY_EQUALS = new KotlinFunctionIntrinsic("equals"){

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (callInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            if (CallInfoExtensionsKt.isSuperInvocation(callInfo)) {
                JsExpression dispatchReceiver = callInfo.getDispatchReceiver();
                assert (arguments2.size() == 1 && dispatchReceiver != null);
                JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(dispatchReceiver, arguments2.get(0));
                if (jsBinaryOperation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
                }
                return jsBinaryOperation;
            }
            JsExpression jsExpression = super.apply(callInfo, arguments2, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            return jsExpression;
        }
    };
    @NotNull
    public static final KotlinFunctionIntrinsic KOTLIN_EQUALS = new KotlinFunctionIntrinsic("equals");
    @NotNull
    private static final DescriptorPredicate HASH_CODE_IN_ANY = PatternBuilder.pattern("kotlin", "Any", "hashCode");
    @NotNull
    private static final KotlinFunctionIntrinsic KOTLIN_HASH_CODE = new KotlinFunctionIntrinsic("hashCode");
    @NotNull
    private static final FunctionIntrinsic RETURN_RECEIVER_INTRINSIC = new FunctionIntrinsic(){

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            assert (receiver != null);
            JsExpression jsExpression = receiver;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            return jsExpression;
        }
    };
    private static final FunctionIntrinsic NATIVE_MAP_GET = new NativeMapGetSet(){

        @Override
        @NotNull
        protected String operationName() {
            if ("get" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$3", "operationName"));
            }
            return "get";
        }

        @Override
        @Nullable
        protected ExpressionReceiver getExpressionReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
            if (resolvedCall2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$3", "getExpressionReceiver"));
            }
            ReceiverValue result2 = resolvedCall2.getDispatchReceiver();
            return result2 instanceof ExpressionReceiver ? (ExpressionReceiver)result2 : null;
        }

        @Override
        protected JsExpression asArrayAccess(@NotNull JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$3", "asArrayAccess"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$3", "asArrayAccess"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$3", "asArrayAccess"));
            }
            return ArrayFIF.GET_INTRINSIC.apply(receiver, arguments2, context);
        }
    };
    private static final FunctionIntrinsic NATIVE_MAP_SET = new NativeMapGetSet(){

        @Override
        @NotNull
        protected String operationName() {
            if ("put" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$4", "operationName"));
            }
            return "put";
        }

        @Override
        @Nullable
        protected ExpressionReceiver getExpressionReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
            if (resolvedCall2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$4", "getExpressionReceiver"));
            }
            Receiver result2 = resolvedCall2.getExtensionReceiver();
            return result2 instanceof ExpressionReceiver ? (ExpressionReceiver)result2 : null;
        }

        @Override
        protected JsExpression asArrayAccess(@NotNull JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$4", "asArrayAccess"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$4", "asArrayAccess"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$4", "asArrayAccess"));
            }
            return ArrayFIF.SET_INTRINSIC.apply(receiver, arguments2, context);
        }
    };
    @NotNull
    public static final KotlinFunctionIntrinsic TO_STRING = new KotlinFunctionIntrinsic("toString");
    @NotNull
    public static final FunctionIntrinsicFactory INSTANCE = new TopLevelFIF();

    private TopLevelFIF() {
        this.add(EQUALS_IN_ANY, KOTLIN_ANY_EQUALS);
        this.add(PatternBuilder.pattern("kotlin", "toString").isExtensionOf(KotlinBuiltIns.FQ_NAMES.any.asString()), TO_STRING);
        this.add(PatternBuilder.pattern("kotlin", "equals").isExtensionOf(KotlinBuiltIns.FQ_NAMES.any.asString()), KOTLIN_EQUALS);
        this.add(HASH_CODE_IN_ANY, KOTLIN_HASH_CODE);
        this.add(PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS, "equals"), KOTLIN_EQUALS);
        this.add(PatternBuilder.pattern("String|Boolean|Char|Number.equals"), KOTLIN_EQUALS);
        this.add(PatternBuilder.pattern("kotlin", "arrayOfNulls"), new KotlinFunctionIntrinsic("nullArray"));
        this.add(PatternBuilder.pattern("kotlin", "iterator").isExtensionOf(KotlinBuiltIns.FQ_NAMES.iterator.asString()), RETURN_RECEIVER_INTRINSIC);
        this.add(PatternBuilder.pattern("kotlin.collections", "Map", "get").checkOverridden(), NATIVE_MAP_GET);
        this.add(PatternBuilder.pattern("kotlin.js", "set").isExtensionOf(KotlinBuiltIns.FQ_NAMES.mutableMap.asString()), NATIVE_MAP_SET);
        this.add(PatternBuilder.pattern("java.util", "HashMap", "<init>"), new MapSelectImplementationIntrinsic(false));
        this.add(PatternBuilder.pattern("java.util", "HashSet", "<init>"), new MapSelectImplementationIntrinsic(true));
        this.add(PatternBuilder.pattern("kotlin.js", "Json", "get"), ArrayFIF.GET_INTRINSIC);
        this.add(PatternBuilder.pattern("kotlin.js", "Json", "set"), ArrayFIF.SET_INTRINSIC);
        this.add(PatternBuilder.pattern("kotlin", "Throwable", "getMessage"), MESSAGE_PROPERTY_INTRINSIC);
    }

    private static class MapSelectImplementationIntrinsic
    extends FunctionIntrinsic.CallParametersAwareFunctionIntrinsic {
        private final boolean isSet;

        private MapSelectImplementationIntrinsic(boolean isSet) {
            this.isSet = isSet;
        }

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (callInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            KotlinType keyType = callInfo.getResolvedCall().getTypeArguments().values().iterator().next();
            Name keyTypeName = DescriptorUtilsKt.getNameIfStandardType(keyType);
            String collectionClassName = null;
            if (keyTypeName != null) {
                if (NamePredicate.PRIMITIVE_NUMBERS.apply(keyTypeName)) {
                    collectionClassName = this.isSet ? "PrimitiveNumberHashSet" : "PrimitiveNumberHashMap";
                } else if (PrimitiveType.BOOLEAN.getTypeName().equals(keyTypeName)) {
                    collectionClassName = this.isSet ? "PrimitiveBooleanHashSet" : "PrimitiveBooleanHashMap";
                } else if (keyTypeName.asString().equals("String")) {
                    String string = collectionClassName = this.isSet ? "DefaultPrimitiveHashSet" : "DefaultPrimitiveHashMap";
                }
            }
            if (collectionClassName == null) {
                collectionClassName = this.isSet ? "ComplexHashSet" : "ComplexHashMap";
            }
            JsNew jsNew = new JsNew(context.namer().kotlin(collectionClassName), arguments2);
            if (jsNew == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            return jsNew;
        }
    }

    private static abstract class NativeMapGetSet
    extends FunctionIntrinsic.CallParametersAwareFunctionIntrinsic {
        private NativeMapGetSet() {
        }

        @NotNull
        protected abstract String operationName();

        @Nullable
        protected abstract ExpressionReceiver getExpressionReceiver(@NotNull ResolvedCall<?> var1);

        protected abstract JsExpression asArrayAccess(@NotNull JsExpression var1, @NotNull List<JsExpression> var2, @NotNull TranslationContext var3);

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (callInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            ExpressionReceiver expressionReceiver = this.getExpressionReceiver(callInfo.getResolvedCall());
            JsExpression thisOrReceiver = NativeMapGetSet.getThisOrReceiverOrNull(callInfo);
            assert (thisOrReceiver != null);
            if (expressionReceiver != null) {
                Object candidate;
                KtExpression expression = expressionReceiver.getExpression();
                KtReferenceExpression referenceExpression = null;
                if (expression instanceof KtReferenceExpression) {
                    referenceExpression = (KtReferenceExpression)expression;
                } else if (expression instanceof KtQualifiedExpression && (candidate = ((KtQualifiedExpression)expression).getReceiverExpression()) instanceof KtReferenceExpression) {
                    referenceExpression = (KtReferenceExpression)candidate;
                }
                if (referenceExpression != null && (candidate = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), referenceExpression)) instanceof PropertyDescriptor && AnnotationsUtils.isNativeObject((DeclarationDescriptor)candidate)) {
                    JsExpression jsExpression = this.asArrayAccess(thisOrReceiver, arguments2, context);
                    if (jsExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
                    }
                    return jsExpression;
                }
            }
            String mangledName = ManglingUtils.getStableMangledNameForDescriptor(JsPlatform.INSTANCE.getBuiltIns().getMutableMap(), this.operationName());
            JsInvocation jsInvocation = new JsInvocation((JsExpression)JsAstUtils.fqnWithoutSideEffects(mangledName, thisOrReceiver), arguments2);
            if (jsInvocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            return jsInvocation;
        }
    }
}

