/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.KotlinFunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.name.Name;

public final class ArrayFIF
extends CompositeFIF {
    private static final NamePredicate NUMBER_ARRAY;
    private static final NamePredicate CHAR_ARRAY;
    private static final NamePredicate BOOLEAN_ARRAY;
    private static final NamePredicate LONG_ARRAY;
    private static final NamePredicate ARRAYS;
    private static final DescriptorPredicate ARRAY_FACTORY_METHODS;
    private static final FunctionIntrinsic ARRAY_INTRINSIC;
    @NotNull
    public static final FunctionIntrinsic GET_INTRINSIC;
    @NotNull
    public static final FunctionIntrinsic SET_INTRINSIC;
    @NotNull
    public static final FunctionIntrinsicFactory INSTANCE;

    private ArrayFIF() {
        this.add(PatternBuilder.pattern(ARRAYS, "get"), GET_INTRINSIC);
        this.add(PatternBuilder.pattern(ARRAYS, "set"), SET_INTRINSIC);
        this.add(PatternBuilder.pattern(ARRAYS, "<get-size>"), LENGTH_PROPERTY_INTRINSIC);
        this.add(PatternBuilder.pattern(ARRAYS, "iterator"), new KotlinFunctionIntrinsic("arrayIterator"));
        this.add(PatternBuilder.pattern(NUMBER_ARRAY, "<init>(Int)"), new KotlinFunctionIntrinsic("numberArrayOfSize"));
        this.add(PatternBuilder.pattern(CHAR_ARRAY, "<init>(Int)"), new KotlinFunctionIntrinsic("charArrayOfSize"));
        this.add(PatternBuilder.pattern(BOOLEAN_ARRAY, "<init>(Int)"), new KotlinFunctionIntrinsic("booleanArrayOfSize"));
        this.add(PatternBuilder.pattern(LONG_ARRAY, "<init>(Int)"), new KotlinFunctionIntrinsic("longArrayOfSize"));
        this.add(PatternBuilder.pattern(ARRAYS, "<init>(Int,Function1)"), new KotlinFunctionIntrinsic("arrayFromFun"));
        this.add(ARRAY_FACTORY_METHODS, ARRAY_INTRINSIC);
    }

    static {
        ArrayList<Name> arrayTypeNames = Lists.newArrayList();
        ArrayList<Name> arrayFactoryMethodNames = Lists.newArrayList(Name.identifier("arrayOf"));
        for (PrimitiveType type2 : PrimitiveType.values()) {
            Name arrayTypeName = type2.getArrayTypeName();
            if (type2 != PrimitiveType.CHAR && type2 != PrimitiveType.BOOLEAN && type2 != PrimitiveType.LONG) {
                arrayTypeNames.add(arrayTypeName);
            }
            arrayFactoryMethodNames.add(Name.identifier(StringUtil.decapitalize(arrayTypeName.asString() + "Of")));
        }
        Name arrayName = KotlinBuiltIns.FQ_NAMES.array.shortName();
        Name booleanArrayName = PrimitiveType.BOOLEAN.getArrayTypeName();
        Name charArrayName = PrimitiveType.CHAR.getArrayTypeName();
        Name longArrayName = PrimitiveType.LONG.getArrayTypeName();
        NUMBER_ARRAY = new NamePredicate((Collection<Name>)arrayTypeNames);
        CHAR_ARRAY = new NamePredicate(charArrayName);
        BOOLEAN_ARRAY = new NamePredicate(booleanArrayName);
        LONG_ARRAY = new NamePredicate(longArrayName);
        arrayTypeNames.add(charArrayName);
        arrayTypeNames.add(booleanArrayName);
        arrayTypeNames.add(longArrayName);
        arrayTypeNames.add(arrayName);
        ARRAYS = new NamePredicate((Collection<Name>)arrayTypeNames);
        ARRAY_FACTORY_METHODS = PatternBuilder.pattern(Namer.KOTLIN_LOWER_NAME, new NamePredicate((Collection<Name>)arrayFactoryMethodNames));
        ARRAY_INTRINSIC = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
                if (arguments2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ArrayFIF$1", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ArrayFIF$1", "apply"));
                }
                assert (arguments2.size() == 1);
                JsExpression jsExpression = arguments2.get(0);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ArrayFIF$1", "apply"));
                }
                return jsExpression;
            }
        };
        GET_INTRINSIC = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
                if (arguments2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ArrayFIF$2", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ArrayFIF$2", "apply"));
                }
                assert (receiver != null);
                assert (arguments2.size() == 1) : "Array get expression must have one argument.";
                JsExpression indexExpression = arguments2.get(0);
                JsArrayAccess result2 = new JsArrayAccess(receiver, indexExpression);
                MetadataProperties.setSideEffects(result2, false);
                JsArrayAccess jsArrayAccess = result2;
                if (jsArrayAccess == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ArrayFIF$2", "apply"));
                }
                return jsArrayAccess;
            }
        };
        SET_INTRINSIC = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
                if (arguments2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ArrayFIF$3", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ArrayFIF$3", "apply"));
                }
                assert (receiver != null);
                assert (arguments2.size() == 2) : "Array set expression must have two arguments.";
                JsExpression indexExpression = arguments2.get(0);
                JsExpression value = arguments2.get(1);
                JsArrayAccess arrayAccess = new JsArrayAccess(receiver, indexExpression);
                JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(arrayAccess, value);
                if (jsBinaryOperation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ArrayFIF$3", "apply"));
                }
                return jsBinaryOperation;
            }
        };
        INSTANCE = new ArrayFIF();
    }
}

