/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.LabelNameRefreshingVisitor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"aliasArgumentsIfNeeded", "", "context", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "arguments", "", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsExpression;", "parameters", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsParameter;", "refreshLabelNames", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsNode;", "node", "scope", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsScope;", "renameLocalNames", "function", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsFunction;", "kotlin-compiler"})
public final class NamingUtilsKt {
    public static final void aliasArgumentsIfNeeded(@NotNull NamingContext context, @NotNull List<? extends JsExpression> arguments2, @NotNull List<JsParameter> parameters2) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        boolean bl = arguments2.size() <= parameters2.size();
        if (!bl) {
            String string = "arguments.size (" + arguments2.size() + ") should be less or equal to parameters.size (" + parameters2.size() + ")";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        for (Pair pair : CollectionsKt.zip((Iterable)arguments2, (Iterable)parameters2)) {
            JsExpression jsExpression;
            JsExpression arg = (JsExpression)pair.component1();
            JsParameter param = (JsParameter)pair.component2();
            JsName paramName = param.getName();
            if (SideEffectUtilsKt.needToAlias(arg)) {
                JsName jsName = paramName;
                Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
                JsName freshName = context.getFreshName(jsName);
                context.newVar(freshName, arg);
                JsExpression jsExpression2 = freshName.makeRef();
                jsExpression = jsExpression2;
                Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "freshName.makeRef()");
            } else {
                jsExpression = arg;
            }
            JsExpression replacement = jsExpression;
            JsName jsName = paramName;
            Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
            context.replaceName(jsName, replacement);
        }
        List<JsParameter> defaultParams = parameters2.subList(arguments2.size(), parameters2.size());
        for (JsParameter defaultParam : defaultParams) {
            JsName paramName;
            JsName jsName = paramName = defaultParam.getName();
            Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
            JsName freshName = context.getFreshName(jsName);
            NamingContext.newVar$default(context, freshName, null, 2, null);
            JsName jsName2 = paramName;
            Intrinsics.checkExpressionValueIsNotNull(jsName2, "paramName");
            JsExpression jsExpression = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "freshName.makeRef()");
            context.replaceName(jsName2, jsExpression);
        }
    }

    public static final void renameLocalNames(@NotNull NamingContext context, @NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(function, "function");
        JsNode jsNode = function.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "function.body");
        for (JsName name : CollectUtilsKt.collectDefinedNames(jsNode)) {
            JsName freshName = context.getFreshName(name);
            JsExpression jsExpression = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "freshName.makeRef()");
            context.replaceName(name, jsExpression);
        }
    }

    @NotNull
    public static final JsNode refreshLabelNames(@NotNull JsNode node, @NotNull JsScope scope2) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        if (!(scope2 instanceof JsFunctionScope)) {
            throw (Throwable)((Object)new AssertionError((Object)"JsFunction is expected to have JsFunctionScope"));
        }
        LabelNameRefreshingVisitor visitor2 = new LabelNameRefreshingVisitor((JsFunctionScope)scope2);
        JsNode jsNode = visitor2.accept(node);
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "visitor.accept(node)");
        return jsNode;
    }
}

