/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/inline/context/FunctionContext;", "", "function", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsFunction;", "functionReader", "Lorg/jetbrains/kotlin/js/inline/FunctionReader;", "(Lcom/google/dart/compiler/backend/js/ast/JsFunction;Lorg/jetbrains/kotlin/js/inline/FunctionReader;)V", "getFunctionDefinition", "call", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsInvocation;", "getFunctionDefinitionImpl", "getScope", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsScope;", "hasFunctionDefinition", "", "lookUpStaticFunction", "functionName", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsName;", "kotlin-compiler"})
public abstract class FunctionContext {
    private final JsFunction function;
    private final FunctionReader functionReader;

    @Nullable
    protected abstract JsFunction lookUpStaticFunction(@Nullable JsName var1);

    @NotNull
    public final JsFunction getFunctionDefinition(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsFunction jsFunction = this.getFunctionDefinitionImpl(call);
        if (jsFunction == null) {
            Intrinsics.throwNpe();
        }
        return jsFunction;
    }

    public final boolean hasFunctionDefinition(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        return this.getFunctionDefinitionImpl(call) != null;
    }

    @NotNull
    public final JsScope getScope() {
        JsScope jsScope = this.function.getScope();
        Intrinsics.checkExpressionValueIsNotNull(jsScope, "function.scope");
        return jsScope;
    }

    private final JsFunction getFunctionDefinitionImpl(JsInvocation call) {
        JsFunction jsFunction;
        JsNode qualifier2;
        Unit unit;
        JsNode jsNode;
        CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(call);
        if (descriptor2 != null && this.functionReader.contains(descriptor2)) {
            return this.functionReader.get(descriptor2);
        }
        JsExpression jsExpression = call.getQualifier();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "call.qualifier");
        JsNode callQualifier = jsExpression;
        if (InvocationUtilsKt.isCallInvocation(call)) {
            JsNode jsNode2 = callQualifier;
            if (jsNode2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNameRef");
            }
            JsExpression jsExpression2 = ((JsNameRef)jsNode2).getQualifier();
            if (jsExpression2 == null) {
                Intrinsics.throwNpe();
            }
            callQualifier = jsExpression2;
        }
        if (callQualifier instanceof JsNameRef) {
            JsNode jsNode3;
            JsName jsName = ((JsNameRef)callQualifier).getName();
            JsNode staticRef = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
            jsNode = staticRef;
            if (jsNode instanceof JsNameRef) {
                JsNode jsNode4 = staticRef;
                if (jsNode4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNode");
                }
                jsNode3 = jsNode4;
            } else if (jsNode instanceof JsInvocation) {
                JsNode jsNode5 = staticRef;
                if (jsNode5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNode");
                }
                jsNode3 = jsNode5;
            } else if (jsNode instanceof JsFunction || Intrinsics.areEqual(jsNode, null)) {
                jsNode3 = callQualifier;
            } else {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected static reference type " + staticRef.getClass())));
            }
            callQualifier = jsNode3;
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        jsNode = qualifier2 = callQualifier;
        if (jsNode instanceof JsInvocation) {
            JsName jsName = InvocationUtilsKt.getSimpleName((JsInvocation)qualifier2);
            if (jsName == null) {
                Intrinsics.throwNpe();
            }
            jsFunction = this.lookUpStaticFunction(jsName);
        } else {
            jsFunction = jsNode instanceof JsNameRef ? this.lookUpStaticFunction(((JsNameRef)qualifier2).getName()) : (JsFunction)null;
        }
        return jsFunction;
    }

    public FunctionContext(@NotNull JsFunction function, @NotNull FunctionReader functionReader) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(functionReader, "functionReader");
        this.function = function;
        this.functionReader = functionReader;
    }
}

