/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jline.console.history;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import org.jetbrains.kotlin.jline.console.history.History;
import org.jetbrains.kotlin.jline.console.history.MemoryHistory;
import org.jetbrains.kotlin.jline.console.history.PersistentHistory;
import org.jetbrains.kotlin.jline.internal.Log;
import org.jetbrains.kotlin.jline.internal.Preconditions;

public class FileHistory
extends MemoryHistory
implements Flushable,
PersistentHistory {
    private final File file;

    public FileHistory(File file) throws IOException {
        this.file = Preconditions.checkNotNull(file);
        this.load(file);
    }

    public void load(File file) throws IOException {
        Preconditions.checkNotNull(file);
        if (file.exists()) {
            Log.trace("Loading history from: ", file);
            this.load(new FileReader(file));
        }
    }

    public void load(Reader reader) throws IOException {
        String item;
        Preconditions.checkNotNull(reader);
        BufferedReader input = new BufferedReader(reader);
        while ((item = input.readLine()) != null) {
            this.internalAdd(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Log.trace("Flushing history");
        if (!this.file.exists()) {
            File dir = this.file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                Log.warn("Failed to create directory: ", dir);
            }
            if (!this.file.createNewFile()) {
                Log.warn("Failed to create file: ", this.file);
            }
        }
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        try {
            for (History.Entry entry : this) {
                out.println(entry.value());
            }
        }
        finally {
            out.close();
        }
    }
}

