/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.reflect.Type;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.container.ComponentDescriptor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\u000f\u001a\u00020\u0005R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/container/ComponentRegistry;", "", "()V", "registrationMap", "Lorg/jetbrains/kotlin/com/intellij/util/containers/MultiMap;", "Ljava/lang/reflect/Type;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "Lorg/jetbrains/annotations/NotNull;", "addAll", "", "descriptors", "", "buildRegistrationMap", "tryGetEntry", "request", "kotlin-compiler"})
public final class ComponentRegistry {
    private MultiMap<Type, ComponentDescriptor> registrationMap = MultiMap.createLinkedSet();

    @NotNull
    public final MultiMap<Type, ComponentDescriptor> buildRegistrationMap(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        MultiMap<Type, ComponentDescriptor> registrationMap = new MultiMap<Type, ComponentDescriptor>();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            for (Type registration : componentDescriptor.getRegistrations()) {
                registrationMap.putValue(registration, componentDescriptor);
            }
        }
        return registrationMap;
    }

    public final void addAll(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        this.registrationMap.putAllValues(this.buildRegistrationMap(descriptors));
    }

    @NotNull
    public final Collection<ComponentDescriptor> tryGetEntry(@NotNull Type request) {
        Intrinsics.checkParameterIsNotNull(request, "request");
        Collection<ComponentDescriptor> collection = this.registrationMap.get(request);
        Intrinsics.checkExpressionValueIsNotNull(collection, "registrationMap.get(request)");
        return collection;
    }
}

