/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.xmlb.BeanBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.SerializationFilter;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializerImpl;
import org.jetbrains.kotlin.org.jdom.Element;

public class XmlSerializer {
    private static final SerializationFilter TRUE_FILTER = new SerializationFilter(){};

    private XmlSerializer() {
    }

    @Nullable
    public static <T> T deserialize(Element element, Class<T> aClass2) throws XmlSerializationException {
        try {
            return (T)XmlSerializerImpl.getBinding(aClass2).deserialize(null, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Cannot deserialize class " + aClass2.getName(), e);
        }
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        XmlSerializer.deserializeInto(bean, element, null);
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        try {
            ((BeanBinding)XmlSerializerImpl.getBinding(bean.getClass())).deserializeInto(bean, element, accessorNameTracker);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }
}

