/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EmptyIcon
implements Icon {
    private static final Map<Integer, Icon> cache = new HashMap<Integer, Icon>();
    public static final Icon ICON_16 = EmptyIcon.create(16);
    public static final Icon ICON_18 = EmptyIcon.create(18);
    public static final Icon ICON_8 = EmptyIcon.create(8);
    public static final Icon ICON_0 = EmptyIcon.create(0);
    private final int width;
    private final int height;

    public static Icon create(int size) {
        Icon icon = cache.get(size);
        if (icon == null && size < 129) {
            icon = new EmptyIcon(size, size);
            cache.put(size, icon);
        }
        return icon == null ? new EmptyIcon(size, size) : icon;
    }

    public static Icon create(int width, int height) {
        return width == height ? EmptyIcon.create(width) : new EmptyIcon(width, height);
    }

    public static Icon create(@NotNull Icon base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "org/jetbrains/kotlin/com/intellij/util/ui/EmptyIcon", "create"));
        }
        return EmptyIcon.create(base.getIconWidth(), base.getIconHeight());
    }

    public EmptyIcon(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int i, int j) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmptyIcon)) {
            return false;
        }
        EmptyIcon icon = (EmptyIcon)o;
        if (this.height != icon.height) {
            return false;
        }
        return this.width == icon.width;
    }

    public int hashCode() {
        int sum = this.width + this.height;
        return sum * (sum + 1) / 2 + this.width;
    }
}

