/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.io.OpenChannelsCache;
import org.jetbrains.kotlin.com.intellij.util.io.Page;
import org.jetbrains.kotlin.com.intellij.util.io.PagePool;

public class RandomAccessDataFile
implements Closeable {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.RandomAccessDataFile");
    private static final OpenChannelsCache ourCache = new OpenChannelsCache(150, "rw");
    private static int ourFilesCount = 0;
    private final int myCount;
    private final File myFile;
    private final PagePool myPool;
    private long lastSeek;
    private volatile long mySize;
    private volatile boolean myIsDirty;
    private volatile boolean myIsDisposed;
    public static int totalReads = 0;
    public static long totalReadBytes = 0L;
    public static int seekcount = 0;
    public static int totalWrites = 0;
    public static long totalWriteBytes = 0L;

    private void releaseFile() {
        ourCache.releaseChannel(this.myFile);
    }

    private RandomAccessFile getRandomAccessFile() throws FileNotFoundException {
        return ourCache.getChannel(this.myFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long physicalLength() {
        long res;
        this.assertNotDisposed();
        try {
            RandomAccessFile file = this.getRandomAccessFile();
            try {
                RandomAccessFile randomAccessFile = file;
                synchronized (randomAccessFile) {
                    res = file.length();
                }
            }
            finally {
                this.releaseFile();
            }
        }
        catch (IOException e) {
            return 0L;
        }
        return res;
    }

    public void dispose() {
        if (this.myIsDisposed) {
            return;
        }
        this.myPool.flushPages(this);
        ourCache.closeChannel(this.myFile);
        this.myIsDisposed = true;
    }

    @Override
    public void close() {
        this.dispose();
    }

    private void assertNotDisposed() {
        if (this.myIsDisposed) {
            LOG.error("storage file is disposed: " + this.myFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadPage(Page page) {
        this.assertNotDisposed();
        try {
            RandomAccessFile file = this.getRandomAccessFile();
            try {
                RandomAccessFile randomAccessFile = file;
                synchronized (randomAccessFile) {
                    this.seek(file, page.getOffset());
                    ByteBuffer buf = page.getBuf();
                    ++totalReads;
                    totalReadBytes += (long)Page.PAGE_SIZE;
                    file.read(buf.array(), 0, Page.PAGE_SIZE);
                    this.lastSeek += (long)Page.PAGE_SIZE;
                }
            }
            finally {
                this.releaseFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void flushPage(Page page, int start, int end) {
        this.assertNotDisposed();
        try {
            this.flush(page.getBuf(), page.getOffset() + (long)start, start, end - start);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(ByteBuffer buf, long fileOffset, int bufOffset, int length) throws IOException {
        if (fileOffset + (long)length > this.mySize) {
            length = (int)(this.mySize - fileOffset);
        }
        RandomAccessFile file = this.getRandomAccessFile();
        try {
            RandomAccessFile randomAccessFile = file;
            synchronized (randomAccessFile) {
                this.seek(file, fileOffset);
                ++totalWrites;
                totalWriteBytes += (long)length;
                file.write(buf.array(), bufOffset, length);
                this.lastSeek += (long)length;
            }
        }
        finally {
            this.releaseFile();
        }
    }

    private void seek(RandomAccessFile file, long fileOffset) throws IOException {
        file.seek(fileOffset);
    }

    public int hashCode() {
        return this.myCount;
    }

    public synchronized String toString() {
        return "RandomAccessFile[" + this.myFile + ", dirty=" + this.myIsDirty + "]";
    }
}

