/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.util.containers.RefHashMap;

public final class WeakHashMap<K, V>
extends RefHashMap<K, V> {
    public WeakHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public WeakHashMap() {
    }

    @Override
    @NotNull
    protected <T> RefHashMap.Key<T> createKey(@NotNull T k, @NotNull ReferenceQueue<? super T> q) {
        if (k == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "org/jetbrains/kotlin/com/intellij/util/containers/WeakHashMap", "createKey"));
        }
        if (q == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "org/jetbrains/kotlin/com/intellij/util/containers/WeakHashMap", "createKey"));
        }
        WeakKey weakKey = new WeakKey(k, q);
        if (weakKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/WeakHashMap", "createKey"));
        }
        return weakKey;
    }

    private static class WeakKey<T>
    extends WeakReference<T>
    implements RefHashMap.Key<T> {
        private final int myHash;

        private WeakKey(@NotNull T k, @NotNull ReferenceQueue<? super T> q) {
            if (k == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "org/jetbrains/kotlin/com/intellij/util/containers/WeakHashMap$WeakKey", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "org/jetbrains/kotlin/com/intellij/util/containers/WeakHashMap$WeakKey", "<init>"));
            }
            super(k, q);
            this.myHash = k.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RefHashMap.Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((RefHashMap.Key)o).get();
            return this.myHash == o.hashCode() && Comparing.equal(t, u);
        }

        public int hashCode() {
            return this.myHash;
        }

        @NonNls
        public String toString() {
            Object t = this.get();
            return "WeakKey(" + t + ", " + this.myHash + ")";
        }
    }
}

