/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.util.AppleHiDPIScaledImage;
import org.jetbrains.kotlin.com.intellij.util.JBHiDPIScaledImage;

public class RetinaImage {
    public static Image createFrom(Image image, int scale, Component ourComponent) {
        int w = image.getWidth(ourComponent);
        int h = image.getHeight(ourComponent);
        BufferedImage hidpi = RetinaImage.create(image, w / scale, h / scale, 2);
        if (SystemInfo.isAppleJvm) {
            Graphics2D g = (Graphics2D)((Image)hidpi).getGraphics();
            g.scale(1.0f / (float)scale, 1.0f / (float)scale);
            g.drawImage(image, 0, 0, null);
            g.dispose();
        }
        return hidpi;
    }

    public static BufferedImage create(int width, int height, int type2) {
        return RetinaImage.create(null, width, height, type2);
    }

    private static BufferedImage create(Image image, int width, int height, int type2) {
        if (SystemInfo.isAppleJvm) {
            return AppleHiDPIScaledImage.create(width, height, type2);
        }
        if (image == null) {
            return new JBHiDPIScaledImage(width, height, type2);
        }
        return new JBHiDPIScaledImage(image, width, height, type2);
    }
}

