/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.reflect.Field;
import java.util.Set;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

class CachedValueChecker {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.CachedValueChecker");
    private static final boolean DO_CHECKS = ApplicationManager.getApplication().isUnitTestMode();
    private static Set<Class> ourCheckedClasses = ContainerUtil.newConcurrentSet();

    static void checkProvider(CachedValueProvider provider, UserDataHolder userDataHolder) {
        if (!DO_CHECKS) {
            return;
        }
        Class<?> providerClass = provider.getClass();
        if (!ourCheckedClasses.add(providerClass)) {
            return;
        }
        for (Field field : providerClass.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object o = field.get(provider);
                if (!(o instanceof PsiElement) || o == userDataHolder) continue;
                LOG.error("Incorrect CachedValue use. Provider references PSI, causing memory leaks and possible invalid element access: field " + field.getName() + " of " + provider);
                return;
            }
            catch (IllegalAccessException e) {
                LOG.error(e);
            }
        }
    }
}

