/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.HashSet;

public class PsiSuperMethodUtil {
    private PsiSuperMethodUtil() {
    }

    public static PsiMethod findConstructorInSuper(PsiMethod constructor) {
        return PsiSuperMethodUtil.findConstructorInSuper(constructor, new HashSet<PsiMethod>());
    }

    public static PsiMethod findConstructorInSuper(PsiMethod constructor, Set<PsiMethod> visited2) {
        PsiClass superClass;
        PsiClass containingClass;
        PsiElement firstChild;
        PsiStatement[] statements;
        if (visited2.contains(constructor)) {
            return null;
        }
        visited2.add(constructor);
        PsiCodeBlock body = constructor.getBody();
        if (body != null && (statements = body.getStatements()).length > 0 && (firstChild = statements[0].getFirstChild()) instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpr = ((PsiMethodCallExpression)firstChild).getMethodExpression();
            String text = methodExpr.getText();
            if (text.equals("super")) {
                PsiElement superConstructor = methodExpr.resolve();
                if (superConstructor instanceof PsiMethod) {
                    return (PsiMethod)superConstructor;
                }
            } else if (text.equals("this")) {
                PsiElement resolved = methodExpr.resolve();
                if (resolved instanceof PsiMethod) {
                    return PsiSuperMethodUtil.findConstructorInSuper((PsiMethod)resolved, visited2);
                }
                return null;
            }
        }
        if ((containingClass = constructor.getContainingClass()) != null && (superClass = containingClass.getSuperClass()) != null) {
            MethodSignature defConstructor = MethodSignatureUtil.createMethodSignature(superClass.getName(), PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY, true);
            return MethodSignatureUtil.findMethodBySignature(superClass, defConstructor, false);
        }
        return null;
    }

    public static boolean isSuperMethod(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiSuperMethodUtil", "isSuperMethod"));
        }
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "org/jetbrains/kotlin/com/intellij/psi/util/PsiSuperMethodUtil", "isSuperMethod"));
        }
        HierarchicalMethodSignature signature2 = method.getHierarchicalMethodSignature();
        List<HierarchicalMethodSignature> superSignatures = signature2.getSuperSignatures();
        int superSignaturesSize = superSignatures.size();
        for (int i = 0; i < superSignaturesSize; ++i) {
            HierarchicalMethodSignature supsig = superSignatures.get(i);
            PsiMethod supsigme = supsig.getMethod();
            if (!superMethod.equals(supsigme) && !PsiSuperMethodUtil.isSuperMethod(supsigme, superMethod)) continue;
            return true;
        }
        return false;
    }
}

