/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.NullableNotNullManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiThisExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.VariableKind;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class PropertyUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PropertyUtil");

    private PropertyUtil() {
    }

    public static boolean isSimplePropertyGetter(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "isSimplePropertyGetter"));
        }
        return PropertyUtil.hasGetterName(method) && method.getParameterList().getParametersCount() == 0;
    }

    public static boolean hasGetterName(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        int methodNameLength = methodName.length();
        if (methodName.startsWith("get") && methodNameLength > "get".length()) {
            if (Character.isLowerCase(methodName.charAt("get".length())) && (methodNameLength == "get".length() + 1 || Character.isLowerCase(methodName.charAt("get".length() + 1)))) {
                return false;
            }
            PsiType returnType2 = method.getReturnType();
            return returnType2 == null || !PsiType.VOID.equals(returnType2);
        }
        if (methodName.startsWith("is") && methodNameLength > "is".length()) {
            if (Character.isLowerCase(methodName.charAt("is".length())) && (methodNameLength == "is".length() + 1 || Character.isLowerCase(methodName.charAt("is".length() + 1)))) {
                return false;
            }
            PsiType returnType3 = method.getReturnType();
            return PropertyUtil.isBoolean(returnType3);
        }
        return false;
    }

    public static boolean isSimplePropertySetter(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        if (!methodName.startsWith("set") || methodName.length() <= "set".length()) {
            return false;
        }
        if (Character.isLowerCase(methodName.charAt("set".length())) && (methodName.length() == "set".length() + 1 || Character.isLowerCase(methodName.charAt("set".length() + 1)))) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiType returnType2 = method.getReturnType();
        if (returnType2 == null || PsiType.VOID.equals(returnType2)) {
            return true;
        }
        return Comparing.equal(PsiUtil.resolveClassInType(TypeConversionUtil.erasure(returnType2)), method.getContainingClass());
    }

    @Nullable
    public static String getPropertyName(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getPropertyName"));
        }
        if (PropertyUtil.isSimplePropertyGetter(method)) {
            return PropertyUtil.getPropertyNameByGetter(method);
        }
        if (PropertyUtil.isSimplePropertySetter(method)) {
            return PropertyUtil.getPropertyNameBySetter(method);
        }
        return null;
    }

    @NotNull
    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        String methodName = getterMethod.getName();
        String string = methodName.startsWith("get") ? StringUtil.decapitalize(methodName.substring(3)) : StringUtil.decapitalize(methodName.substring(2));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getPropertyNameByGetter"));
        }
        return string;
    }

    @NotNull
    public static String getPropertyNameBySetter(@NotNull PsiMethod setterMethod) {
        if (setterMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setterMethod", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getPropertyNameBySetter"));
        }
        String methodName = setterMethod.getName();
        String string = Introspector.decapitalize(methodName.substring(3));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getPropertyNameBySetter"));
        }
        return string;
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getAllProperties"));
        }
        Map<String, PsiMethod> map2 = PropertyUtil.getAllProperties(psiClass, acceptSetters, acceptGetters, true);
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getAllProperties"));
        }
        return map2;
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters, boolean includeSuperClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getAllProperties"));
        }
        Map<String, PsiMethod> map2 = PropertyUtil.getAllProperties(acceptSetters, acceptGetters, includeSuperClass ? psiClass.getAllMethods() : psiClass.getMethods());
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getAllProperties"));
        }
        return map2;
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(boolean acceptSetters, boolean acceptGetters, PsiMethod[] methods2) {
        HashMap<String, PsiMethod> map2 = new HashMap<String, PsiMethod>();
        for (PsiMethod method : methods2) {
            if (PropertyUtil.filterMethods(method) || (!acceptSetters || !PropertyUtil.isSimplePropertySetter(method)) && (!acceptGetters || !PropertyUtil.isSimplePropertyGetter(method))) continue;
            map2.put(PropertyUtil.getPropertyName(method), method);
        }
        HashMap<String, PsiMethod> hashMap = map2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getAllProperties"));
        }
        return hashMap;
    }

    private static boolean filterMethods(PsiMethod method) {
        if (method.hasModifierProperty("static") || !method.hasModifierProperty("public")) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        String className2 = psiClass.getQualifiedName();
        return "java.lang.Object".equals(className2);
    }

    @NotNull
    public static List<PsiMethod> getSetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getSetters"));
        }
        String setterName = PropertyUtil.suggestSetterName(propertyName);
        PsiMethod[] psiMethods = psiClass.findMethodsByName(setterName, true);
        ArrayList<PsiMethod> list2 = new ArrayList<PsiMethod>(psiMethods.length);
        for (PsiMethod method : psiMethods) {
            if (PropertyUtil.filterMethods(method) || !PropertyUtil.isSimplePropertySetter(method)) continue;
            list2.add(method);
        }
        ArrayList<PsiMethod> arrayList = list2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getSetters"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiMethod> getGetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getGetters"));
        }
        String[] names2 = PropertyUtil.suggestGetterNames(propertyName);
        ArrayList<PsiMethod> list2 = new ArrayList<PsiMethod>();
        for (String name : names2) {
            PsiMethod[] psiMethods;
            for (PsiMethod method : psiMethods = psiClass.findMethodsByName(name, true)) {
                if (PropertyUtil.filterMethods(method) || !PropertyUtil.isSimplePropertyGetter(method)) continue;
                list2.add(method);
            }
        }
        ArrayList<PsiMethod> arrayList = list2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getGetters"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiMethod> getAccessors(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getAccessors"));
        }
        List<PsiMethod> list2 = ContainerUtil.concat(PropertyUtil.getGetters(psiClass, propertyName), PropertyUtil.getSetters(psiClass, propertyName));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getAccessors"));
        }
        return list2;
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass2, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        String[] getterCandidateNames;
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "findPropertyGetter"));
        }
        if (aClass2 == null) {
            return null;
        }
        for (String getterCandidateName : getterCandidateNames = PropertyUtil.suggestGetterNames(propertyName)) {
            PsiMethod[] getterCandidates;
            for (PsiMethod method : getterCandidates = aClass2.findMethodsByName(getterCandidateName, checkSuperClasses)) {
                if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertyGetter(method) || !PropertyUtil.getPropertyNameByGetter(method).equals(propertyName)) continue;
                return method;
            }
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertyGetterWithType(String propertyName, boolean isStatic, PsiType type2, Iterator<PsiMethod> methods2) {
        while (methods2.hasNext()) {
            PsiMethod method = methods2.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertyGetter(method) || !PropertyUtil.getPropertyNameByGetter(method).equals(propertyName) || !type2.equals(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method) {
        return PropertyUtil.isSimplePropertyGetter(method) || PropertyUtil.isSimplePropertySetter(method);
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass2, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        PsiMethod[] methods2;
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "findPropertySetter"));
        }
        if (aClass2 == null) {
            return null;
        }
        String setterName = PropertyUtil.suggestSetterName(propertyName);
        for (PsiMethod method : methods2 = aClass2.findMethodsByName(setterName, checkSuperClasses)) {
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertySetter(method) || !PropertyUtil.getPropertyNameBySetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertySetterWithType(String propertyName, boolean isStatic, PsiType type2, Iterator<PsiMethod> methods2) {
        while (methods2.hasNext()) {
            PsiType methodType;
            PsiMethod method = methods2.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertySetter(method) || !PropertyUtil.getPropertyNameBySetter(method).equals(propertyName) || !type2.equals(methodType = method.getParameterList().getParameters()[0].getType())) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyField(PsiClass aClass2, String propertyName, boolean isStatic) {
        PsiField[] fields2;
        for (PsiField field : fields2 = aClass2.getAllFields()) {
            if (field.hasModifierProperty("static") != isStatic || !propertyName.equals(PropertyUtil.suggestPropertyName(field))) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static String getPropertyName(@NonNls String methodName) {
        return StringUtil.getPropertyName(methodName);
    }

    public static String suggestGetterName(@NonNls @NotNull String propertyName, @Nullable PsiType propertyType) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "suggestGetterName"));
        }
        return PropertyUtil.suggestGetterName(propertyName, propertyType, null);
    }

    public static String suggestGetterName(@NotNull String propertyName, @Nullable PsiType propertyType, @NonNls String existingGetterName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "suggestGetterName"));
        }
        StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention(StringUtil.sanitizeJavaIdentifier(propertyName)));
        if (PropertyUtil.isBoolean(propertyType)) {
            if (existingGetterName == null || !existingGetterName.startsWith("get")) {
                name.insert(0, "is");
            } else {
                name.insert(0, "get");
            }
        } else {
            name.insert(0, "get");
        }
        return name.toString();
    }

    private static boolean isBoolean(@Nullable PsiType propertyType) {
        return PsiType.BOOLEAN.equals(propertyType);
    }

    @NonNls
    @NotNull
    public static String[] suggestGetterNames(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "suggestGetterNames"));
        }
        String str = StringUtil.capitalizeWithJavaBeanConvention(StringUtil.sanitizeJavaIdentifier(propertyName));
        String[] stringArray = new String[]{"is" + str, "get" + str};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "suggestGetterNames"));
        }
        return stringArray;
    }

    public static String suggestSetterName(@NonNls @NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "suggestSetterName"));
        }
        return PropertyUtil.suggestSetterName(propertyName, "set");
    }

    public static String suggestSetterName(@NonNls @NotNull String propertyName, String setterPrefix) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "suggestSetterName"));
        }
        String sanitizeJavaIdentifier = StringUtil.sanitizeJavaIdentifier(propertyName);
        if (StringUtil.isEmpty(setterPrefix)) {
            return sanitizeJavaIdentifier;
        }
        StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention(sanitizeJavaIdentifier));
        name.insert(0, setterPrefix);
        return name.toString();
    }

    @NotNull
    public static String[] getReadableProperties(@NotNull PsiClass aClass2, boolean includeSuperClass) {
        PsiMethod[] methods2;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getReadableProperties"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (PsiMethod method : methods2 = includeSuperClass ? aClass2.getAllMethods() : aClass2.getMethods()) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtil.isSimplePropertyGetter(method)) continue;
            result2.add(PropertyUtil.getPropertyName(method));
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getReadableProperties"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] getWritableProperties(@NotNull PsiClass aClass2, boolean includeSuperClass) {
        PsiMethod[] methods2;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getWritableProperties"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (PsiMethod method : methods2 = includeSuperClass ? aClass2.getAllMethods() : aClass2.getMethods()) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtil.isSimplePropertySetter(method)) continue;
            result2.add(PropertyUtil.getPropertyName(method));
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getWritableProperties"));
        }
        return stringArray;
    }

    @Nullable
    public static PsiMethod generateGetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "generateGetterPrototype"));
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(field.getProject()).getElementFactory();
        Project project = field.getProject();
        String name = field.getName();
        String getName = PropertyUtil.suggestGetterName(field);
        try {
            PsiMethod getMethod = factory.createMethod(getName, field.getType());
            PsiUtil.setModifierProperty(getMethod, "public", true);
            if (field.hasModifierProperty("static")) {
                PsiUtil.setModifierProperty(getMethod, "static", true);
            }
            NullableNotNullManager.getInstance(project).copyNullableOrNotNullAnnotation(field, getMethod);
            PsiCodeBlock body = factory.createCodeBlockFromText("{\nreturn " + name + ";\n}", null);
            getMethod.getBody().replace(body);
            getMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(getMethod);
            return getMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "generateSetterPrototype"));
        }
        return PropertyUtil.generateSetterPrototype(field, field.getContainingClass());
    }

    @Nullable
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, @NotNull PsiClass containingClass) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "generateSetterPrototype"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "generateSetterPrototype"));
        }
        return PropertyUtil.generateSetterPrototype(field, containingClass, false);
    }

    @Nullable
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, @NotNull PsiClass containingClass, boolean returnSelf) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "generateSetterPrototype"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "generateSetterPrototype"));
        }
        Project project = field.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
        PsiElementFactory factory = JavaPsiFacade.getInstance(field.getProject()).getElementFactory();
        String name = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String propertyName = codeStyleManager.variableNameToPropertyName(name, kind);
        String setName = PropertyUtil.suggestSetterName(field);
        try {
            PsiMethod setMethod = factory.createMethodFromText(factory.createMethod(setName, returnSelf ? factory.createType(containingClass) : PsiType.VOID).getText(), field);
            String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
            PsiParameter param = factory.createParameter(parameterName, field.getType());
            NullableNotNullManager.getInstance(project).copyNullableOrNotNullAnnotation(field, param);
            setMethod.getParameterList().add(param);
            PsiUtil.setModifierProperty(setMethod, "public", true);
            PsiUtil.setModifierProperty(setMethod, "static", isStatic);
            StringBuilder buffer = new StringBuilder();
            buffer.append("{\n");
            if (name.equals(parameterName)) {
                if (!isStatic) {
                    buffer.append("this.");
                } else {
                    String className2 = containingClass.getName();
                    if (className2 != null) {
                        buffer.append(className2);
                        buffer.append(".");
                    }
                }
            }
            buffer.append(name);
            buffer.append("=");
            buffer.append(parameterName);
            buffer.append(";\n");
            if (returnSelf) {
                buffer.append("return this;\n");
            }
            buffer.append("}");
            PsiCodeBlock body = factory.createCodeBlockFromText(buffer.toString(), null);
            setMethod.getBody().replace(body);
            setMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(setMethod);
            return setMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
    }

    public static void annotateWithNullableStuff(@NotNull PsiModifierListOwner field, @NotNull PsiModifierListOwner listOwner) throws IncorrectOperationException {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "annotateWithNullableStuff"));
        }
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "annotateWithNullableStuff"));
        }
        NullableNotNullManager.getInstance(field.getProject()).copyNullableOrNotNullAnnotation(field, listOwner);
    }

    public static String suggestPropertyName(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "suggestPropertyName"));
        }
        return PropertyUtil.suggestPropertyName(field, field.getName());
    }

    public static String suggestPropertyName(@NotNull PsiField field, @NotNull String fieldName) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "suggestPropertyName"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "suggestPropertyName"));
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(field.getProject());
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String name = codeStyleManager.variableNameToPropertyName(fieldName, kind);
        if (!field.hasModifierProperty("static") && PropertyUtil.isBoolean(field.getType()) && name.startsWith("is") && name.length() > "is".length() && Character.isUpperCase(name.charAt("is".length()))) {
            name = Introspector.decapitalize(name.substring("is".length()));
        }
        return name;
    }

    public static String suggestGetterName(PsiField field) {
        String propertyName = PropertyUtil.suggestPropertyName(field);
        return PropertyUtil.suggestGetterName(propertyName, field.getType());
    }

    public static String suggestSetterName(PsiField field) {
        String propertyName = PropertyUtil.suggestPropertyName(field);
        return PropertyUtil.suggestSetterName(propertyName);
    }

    @Nullable
    public static String getPropertyName(PsiMember member) {
        if (member instanceof PsiMethod) {
            return PropertyUtil.getPropertyName((PsiMethod)member);
        }
        if (member instanceof PsiField) {
            return member.getName();
        }
        return null;
    }

    @Nullable
    public static PsiType getPropertyType(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getType();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtil.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnType();
            }
            if (PropertyUtil.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getType();
            }
        }
        return null;
    }

    @Nullable
    public static PsiTypeElement getPropertyTypeElement(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getTypeElement();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtil.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnTypeElement();
            }
            if (PropertyUtil.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getTypeElement();
            }
        }
        return null;
    }

    @Nullable
    public static PsiIdentifier getPropertyNameIdentifier(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getNameIdentifier();
        }
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).getNameIdentifier();
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyFieldByMember(PsiMember psiMember) {
        if (psiMember instanceof PsiField) {
            return (PsiField)psiMember;
        }
        if (psiMember instanceof PsiMethod) {
            PsiElement resolved;
            PsiExpression target;
            PsiStatement statement;
            PsiMethod psiMethod = (PsiMethod)psiMember;
            PsiType returnType2 = psiMethod.getReturnType();
            if (returnType2 == null) {
                return null;
            }
            PsiCodeBlock body = psiMethod.getBody();
            PsiStatement[] statements = body == null ? null : body.getStatements();
            PsiStatement psiStatement = statement = statements == null || statements.length != 1 ? null : statements[0];
            if (PsiType.VOID.equals(returnType2)) {
                PsiExpression expression = statement instanceof PsiExpressionStatement ? ((PsiExpressionStatement)statement).getExpression() : null;
                target = expression instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)expression).getLExpression() : null;
            } else {
                target = statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null;
            }
            PsiElement psiElement = resolved = target instanceof PsiReferenceExpression ? ((PsiReferenceExpression)target).resolve() : null;
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                if (psiMember.getContainingClass() == field.getContainingClass() || psiMember.getContainingClass().isInheritor(field.getContainingClass(), true)) {
                    return field;
                }
            }
        }
        return null;
    }

    public static PsiMethod findSetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = PropertyUtil.suggestPropertyName(field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtil.findPropertySetter(containingClass, propertyName, isStatic, true);
    }

    public static PsiMethod findGetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = PropertyUtil.suggestPropertyName(field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtil.findPropertyGetter(containingClass, propertyName, isStatic, true);
    }

    @Nullable
    public static PsiExpression getGetterReturnExpression(PsiMethod method) {
        return method != null && PropertyUtil.hasGetterSignature(method) ? PropertyUtil.getSingleReturnValue(method) : null;
    }

    private static boolean hasGetterSignature(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "hasGetterSignature"));
        }
        return PropertyUtil.isSimplePropertyGetter(method) && !method.hasModifierProperty("synchronized");
    }

    @Nullable
    public static PsiExpression getSingleReturnValue(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "getSingleReturnValue"));
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        PsiStatement statement = statements.length != 1 ? null : statements[0];
        return statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null;
    }

    @Nullable
    public static PsiField getFieldOfGetter(PsiMethod method) {
        PsiType returnType2;
        PsiField field = PropertyUtil.getSimplyReturnedField(method, PropertyUtil.getGetterReturnExpression(method));
        if (field != null && (returnType2 = method.getReturnType()) != null && field.getType().equalsToText(returnType2.getCanonicalText())) {
            return field;
        }
        return null;
    }

    @Nullable
    public static PsiField getSimplyReturnedField(PsiMethod method, @Nullable PsiExpression value) {
        if (!(value instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)value;
        if (PropertyUtil.hasSubstantialQualifier(reference)) {
            return null;
        }
        PsiElement referent = reference.resolve();
        if (!(referent instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)referent;
        return InheritanceUtil.isInheritorOrSelf(method.getContainingClass(), field.getContainingClass(), true) ? field : null;
    }

    private static boolean hasSubstantialQualifier(PsiReferenceExpression reference) {
        PsiExpression qualifier2 = reference.getQualifierExpression();
        if (qualifier2 == null) {
            return false;
        }
        if (qualifier2 instanceof PsiThisExpression || qualifier2 instanceof PsiSuperExpression) {
            return false;
        }
        if (qualifier2 instanceof PsiReferenceExpression) {
            return !(((PsiReferenceExpression)qualifier2).resolve() instanceof PsiClass);
        }
        return true;
    }

    public static boolean isSimpleGetter(PsiMethod method) {
        return PropertyUtil.getFieldOfGetter(method) != null;
    }

    @Nullable
    public static PsiField getFieldOfSetter(PsiMethod method) {
        PsiType parameterType;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (method == null) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 1) {
            return null;
        }
        String name = method.getName();
        if (!name.startsWith("set")) {
            return null;
        }
        if (method.hasModifierProperty("synchronized")) {
            return null;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return null;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpressionStatement possibleAssignmentStatement = (PsiExpressionStatement)statement;
        PsiExpression possibleAssignment = possibleAssignmentStatement.getExpression();
        if (!(possibleAssignment instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)possibleAssignment;
        if (!JavaTokenType.EQ.equals(assignment.getOperationTokenType())) {
            return null;
        }
        PsiExpression lhs = assignment.getLExpression();
        if (!(lhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
        PsiExpression qualifier2 = reference.getQualifierExpression();
        if (qualifier2 instanceof PsiReferenceExpression ? !((target = (referenceExpression = (PsiReferenceExpression)qualifier2).resolve()) instanceof PsiClass) : qualifier2 != null && !(qualifier2 instanceof PsiThisExpression) && !(qualifier2 instanceof PsiSuperExpression)) {
            return null;
        }
        PsiElement referent = reference.resolve();
        if (referent == null) {
            return null;
        }
        if (!(referent instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)referent;
        PsiClass fieldContainingClass = field.getContainingClass();
        PsiClass methodContainingClass = method.getContainingClass();
        if (!InheritanceUtil.isInheritorOrSelf(methodContainingClass, fieldContainingClass, true)) {
            return null;
        }
        PsiExpression rhs = assignment.getRExpression();
        if (!(rhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression rReference = (PsiReferenceExpression)rhs;
        PsiExpression rQualifier = rReference.getQualifierExpression();
        if (rQualifier != null) {
            return null;
        }
        PsiElement rReferent = rReference.resolve();
        if (rReferent == null) {
            return null;
        }
        if (!(rReferent instanceof PsiParameter)) {
            return null;
        }
        PsiType fieldType = field.getType();
        if (fieldType.equalsToText((parameterType = ((PsiVariable)rReferent).getType()).getCanonicalText())) {
            return field;
        }
        return null;
    }

    public static boolean isSimpleSetter(PsiMethod method) {
        return PropertyUtil.getFieldOfSetter(method) != null;
    }

    @Nullable
    public static PsiMethod getReversePropertyMethod(PsiMethod propertyMethod) {
        PsiField field;
        String prefix;
        if (propertyMethod == null) {
            return null;
        }
        PsiClass aClass2 = propertyMethod.getContainingClass();
        if (aClass2 == null) {
            return null;
        }
        String methodName = propertyMethod.getName();
        if (methodName.startsWith("get")) {
            prefix = "get";
        } else if (methodName.startsWith("is")) {
            prefix = "is";
        } else if (methodName.startsWith("set")) {
            prefix = "set";
        } else {
            return null;
        }
        String name = methodName.substring(prefix.length());
        PsiField psiField = field = prefix.equals("set") ? PropertyUtil.getFieldOfSetter(propertyMethod) : PropertyUtil.getFieldOfGetter(propertyMethod);
        if (field == null) {
            return null;
        }
        if (prefix.equals("set")) {
            PsiMethod result2 = PropertyUtil.findPropertyMethod(aClass2, "get", name, field);
            if (result2 != null) {
                return result2;
            }
            return PropertyUtil.findPropertyMethod(aClass2, "is", name, field);
        }
        return PropertyUtil.findPropertyMethod(aClass2, "set", name, field);
    }

    private static PsiMethod findPropertyMethod(@NotNull PsiClass aClass2, @NotNull String prefix, @NotNull String propertyName, @NotNull PsiField field1) {
        PsiMethod[] methods2;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "findPropertyMethod"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "findPropertyMethod"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "findPropertyMethod"));
        }
        if (field1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field1", "org/jetbrains/kotlin/com/intellij/psi/util/PropertyUtil", "findPropertyMethod"));
        }
        for (PsiMethod method : methods2 = aClass2.findMethodsByName(prefix + propertyName, true)) {
            PsiField field2;
            PsiField psiField = field2 = prefix.equals("set") ? PropertyUtil.getFieldOfSetter(method) : PropertyUtil.getFieldOfGetter(method);
            if (!field1.equals(field2)) continue;
            return method;
        }
        return null;
    }
}

