/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class LambdaExpressionCompatibilityConstraint
implements ConstraintFormula {
    private final PsiLambdaExpression myExpression;
    private PsiType myT;

    public LambdaExpressionCompatibilityConstraint(PsiLambdaExpression expression, PsiType t) {
        this.myExpression = expression;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        if (!LambdaUtil.isFunctionalType(this.myT)) {
            return false;
        }
        PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT, this.myExpression, false);
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (interfaceMethod == null) {
            return false;
        }
        PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
        PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
        PsiParameter[] lambdaParameters = this.myExpression.getParameterList().getParameters();
        if (lambdaParameters.length != parameters2.length) {
            return false;
        }
        if (this.myExpression.hasFormalParameterTypes()) {
            for (int i = 0; i < lambdaParameters.length; ++i) {
                constraints.add(new TypeEqualityConstraint(lambdaParameters[i].getType(), substitutor2.substitute(parameters2[i].getType())));
            }
            constraints.add(new StrictSubtypingConstraint(this.myT, groundTargetType));
        } else {
            for (PsiParameter parameter : parameters2) {
                if (session.isProperType(session.substituteWithInferenceVariables(substitutor2.substitute(parameter.getType())))) continue;
                return false;
            }
        }
        PsiType returnType2 = interfaceMethod.getReturnType();
        if (returnType2 != null) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(this.myExpression);
            if (returnType2.equals(PsiType.VOID)) {
                if (!this.myExpression.isVoidCompatible()) {
                    return false;
                }
            } else {
                if (!this.myExpression.isValueCompatible()) {
                    return false;
                }
                InferenceSession callsession = session.findNestedCallSession(this.myExpression);
                if (!callsession.isProperType(returnType2 = callsession.substituteWithInferenceVariables(substitutor2.substitute(returnType2)))) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        constraints.add(new ExpressionCompatibilityConstraint(returnExpression, returnType2));
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

